/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import java.util.concurrent.Callable;

public final class BasicGauge<T extends Number>
extends AbstractMonitor<T>
implements Gauge<T> {
    private final Callable<T> function;

    public BasicGauge(MonitorConfig config, Callable<T> function) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.function = function;
    }

    @Override
    public T getValue(int pollerIndex) {
        try {
            return (T)((Number)this.function.call());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BasicGauge)) {
            return false;
        }
        BasicGauge m = (BasicGauge)obj;
        return this.config.equals(m.getConfig()) && this.function.equals(m.function);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.function});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("function", this.function).toString();
    }
}

