/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractNode;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpSocketTransportFactory;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class OtpEpmd {
    private static final byte stopReq = 115;
    private static final byte port4req = 122;
    private static final byte port4resp = 119;
    private static final byte publish4req = 120;
    private static final byte publish4resp = 121;
    private static final byte names4req = 110;
    private static int traceLevel = 0;
    private static final int traceThreshold = 4;

    private OtpEpmd() {
    }

    public static void useEpmdPort(int n) {
        EpmdPort.set(n);
    }

    public static int lookupPort(AbstractNode abstractNode) throws IOException {
        return OtpEpmd.r4_lookupPort(abstractNode);
    }

    public static boolean publishPort(OtpLocalNode otpLocalNode) throws IOException {
        OtpTransport otpTransport = null;
        otpTransport = OtpEpmd.r4_publish(otpLocalNode);
        otpLocalNode.setEpmd(otpTransport);
        return otpTransport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unPublishPort(OtpLocalNode otpLocalNode) {
        OtpTransport otpTransport = null;
        try {
            otpTransport = otpLocalNode.createTransport((String)null, EpmdPort.get());
            OtpOutputStream otpOutputStream = new OtpOutputStream();
            otpOutputStream.write2BE(otpLocalNode.alive().length() + 1);
            otpOutputStream.write1(115L);
            otpOutputStream.writeN(otpLocalNode.alive().getBytes());
            otpOutputStream.writeToAndFlush(otpTransport.getOutputStream());
            if (traceLevel >= 4) {
                System.out.println("-> UNPUBLISH " + otpLocalNode + " port=" + otpLocalNode.port());
                System.out.println("<- OK (assumed)");
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (otpTransport != null) {
                    otpTransport.close();
                }
            }
            catch (IOException iOException) {}
            otpTransport = null;
        }
    }

    private static int r4_lookupPort(AbstractNode abstractNode) throws IOException {
        int n = 0;
        OtpTransport otpTransport = null;
        try {
            int n2;
            OtpOutputStream otpOutputStream = new OtpOutputStream();
            otpTransport = abstractNode.createTransport(abstractNode.host(), EpmdPort.get());
            otpOutputStream.write2BE(abstractNode.alive().length() + 1);
            otpOutputStream.write1(122L);
            otpOutputStream.writeN(abstractNode.alive().getBytes());
            otpOutputStream.writeToAndFlush(otpTransport.getOutputStream());
            if (traceLevel >= 4) {
                System.out.println("-> LOOKUP (r4) " + abstractNode);
            }
            byte[] byArray = new byte[100];
            int n3 = otpTransport.getInputStream().read(byArray);
            if (n3 < 0) {
                otpTransport.close();
                throw new IOException("Nameserver not responding on " + abstractNode.host() + " when looking up " + abstractNode.alive());
            }
            OtpInputStream otpInputStream = new OtpInputStream(byArray, 0);
            int n4 = otpInputStream.read1();
            if (n4 == 119 && (n2 = otpInputStream.read1()) == 0) {
                n = otpInputStream.read2BE();
                abstractNode.ntype = otpInputStream.read1();
                abstractNode.proto = otpInputStream.read1();
                abstractNode.distHigh = otpInputStream.read2BE();
                abstractNode.distLow = otpInputStream.read2BE();
            }
        }
        catch (IOException iOException) {
            if (traceLevel >= 4) {
                System.out.println("<- (no response)");
            }
            throw new IOException("Nameserver not responding on " + abstractNode.host() + " when looking up " + abstractNode.alive(), iOException);
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            if (traceLevel >= 4) {
                System.out.println("<- (invalid response)");
            }
            throw new IOException("Nameserver not responding on " + abstractNode.host() + " when looking up " + abstractNode.alive());
        }
        finally {
            try {
                if (otpTransport != null) {
                    otpTransport.close();
                }
            }
            catch (IOException iOException) {}
            otpTransport = null;
        }
        if (traceLevel >= 4) {
            if (n == 0) {
                System.out.println("<- NOT FOUND");
            } else {
                System.out.println("<- PORT " + n);
            }
        }
        return n;
    }

    private static OtpTransport r4_publish(OtpLocalNode otpLocalNode) throws IOException {
        OtpTransport otpTransport = null;
        try {
            int n;
            OtpOutputStream otpOutputStream = new OtpOutputStream();
            otpTransport = otpLocalNode.createTransport((String)null, EpmdPort.get());
            otpOutputStream.write2BE(otpLocalNode.alive().length() + 13);
            otpOutputStream.write1(120L);
            otpOutputStream.write2BE(otpLocalNode.port());
            otpOutputStream.write1(otpLocalNode.type());
            otpOutputStream.write1(otpLocalNode.proto());
            otpOutputStream.write2BE(otpLocalNode.distHigh());
            otpOutputStream.write2BE(otpLocalNode.distLow());
            otpOutputStream.write2BE(otpLocalNode.alive().length());
            otpOutputStream.writeN(otpLocalNode.alive().getBytes());
            otpOutputStream.write2BE(0L);
            otpOutputStream.writeToAndFlush(otpTransport.getOutputStream());
            if (traceLevel >= 4) {
                System.out.println("-> PUBLISH (r4) " + otpLocalNode + " port=" + otpLocalNode.port());
            }
            byte[] byArray = new byte[100];
            int n2 = otpTransport.getInputStream().read(byArray);
            if (n2 < 0) {
                otpTransport.close();
                throw new IOException("Nameserver not responding on " + otpLocalNode.host() + " when publishing " + otpLocalNode.alive());
            }
            OtpInputStream otpInputStream = new OtpInputStream(byArray, 0);
            int n3 = otpInputStream.read1();
            if (n3 == 121 && (n = otpInputStream.read1()) == 0) {
                otpLocalNode.creation = otpInputStream.read2BE();
                if (traceLevel >= 4) {
                    System.out.println("<- OK");
                }
                return otpTransport;
            }
        }
        catch (IOException iOException) {
            if (otpTransport != null) {
                otpTransport.close();
            }
            if (traceLevel >= 4) {
                System.out.println("<- (no response)");
            }
            throw new IOException("Nameserver not responding on " + otpLocalNode.host() + " when publishing " + otpLocalNode.alive());
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            otpTransport.close();
            if (traceLevel >= 4) {
                System.out.println("<- (invalid response)");
            }
            throw new IOException("Nameserver not responding on " + otpLocalNode.host() + " when publishing " + otpLocalNode.alive());
        }
        otpTransport.close();
        return null;
    }

    public static String[] lookupNames() throws IOException {
        return OtpEpmd.lookupNames(InetAddress.getByName(null), new OtpSocketTransportFactory());
    }

    public static String[] lookupNames(OtpTransportFactory otpTransportFactory) throws IOException {
        return OtpEpmd.lookupNames(InetAddress.getByName(null), otpTransportFactory);
    }

    public static String[] lookupNames(InetAddress inetAddress) throws IOException {
        return OtpEpmd.lookupNames(inetAddress, new OtpSocketTransportFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupNames(InetAddress inetAddress, OtpTransportFactory otpTransportFactory) throws IOException {
        String[] stringArray;
        block11: {
            OtpTransport otpTransport = null;
            OtpOutputStream otpOutputStream = new OtpOutputStream();
            try {
                int n;
                otpTransport = otpTransportFactory.createTransport(inetAddress, EpmdPort.get());
                otpOutputStream.write2BE(1L);
                otpOutputStream.write1(110L);
                otpOutputStream.writeToAndFlush(otpTransport.getOutputStream());
                if (traceLevel >= 4) {
                    System.out.println("-> NAMES (r4) ");
                }
                byte[] byArray = new byte[256];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
                while ((n = otpTransport.getInputStream().read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                OtpInputStream otpInputStream = new OtpInputStream(byArray2, 0);
                otpInputStream.read4BE();
                int n2 = byArray2.length;
                byte[] byArray3 = new byte[n2 - 4];
                System.arraycopy(byArray2, 4, byArray3, 0, n2 - 4);
                String string = OtpErlangString.newString(byArray3);
                stringArray = string.split("\n");
                if (otpTransport == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (otpTransport != null) {
                        otpTransport.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    if (traceLevel >= 4) {
                        System.out.println("<- (no response)");
                    }
                    throw new IOException("Nameserver not responding when requesting names");
                }
                catch (OtpErlangDecodeException otpErlangDecodeException) {
                    if (traceLevel >= 4) {
                        System.out.println("<- (invalid response)");
                    }
                    throw new IOException("Nameserver not responding when requesting names");
                }
            }
            otpTransport.close();
        }
        return stringArray;
    }

    static {
        String string = System.getProperties().getProperty("OtpConnection.trace");
        try {
            if (string != null) {
                traceLevel = Integer.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            traceLevel = 0;
        }
    }

    private static class EpmdPort {
        private static int epmdPort = 0;

        private EpmdPort() {
        }

        public static int get() {
            if (epmdPort == 0) {
                String string;
                try {
                    string = System.getenv("ERL_EPMD_PORT");
                }
                catch (SecurityException securityException) {
                    string = null;
                }
                epmdPort = string != null ? Integer.parseInt(string) : 4369;
            }
            return epmdPort;
        }

        public static void set(int n) {
            epmdPort = n;
        }
    }
}

