/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.common.i18n.Messages;

public class ParametersDialog
extends FreeColDialog<Parameters> {
    private static final int COLUMNS = 5;
    private static final int DEFAULT_distToLandFromHighSeas = 4;
    private static final int DEFAULT_maxDistanceToEdge = 12;
    private final JTextField inputD;
    private final JTextField inputM;

    public ParametersDialog(FreeColClient freeColClient, JFrame frame) {
        super(freeColClient, frame);
        MigPanel panel = new MigPanel(new MigLayout("wrap 1, center"));
        JPanel widthPanel = new JPanel(new FlowLayout());
        JPanel heightPanel = new JPanel(new FlowLayout());
        String str = Integer.toString(4);
        this.inputD = new JTextField(str, 5);
        str = Integer.toString(12);
        this.inputM = new JTextField(str, 5);
        str = Messages.message("parametersDialog.determineHighSeas.distToLandFromHighSeas");
        JLabel widthLabel = new JLabel(str);
        widthLabel.setLabelFor(this.inputD);
        str = Messages.message("parametersDialog.determineHighSeas.maxDistanceToEdge");
        JLabel heightLabel = new JLabel(str);
        heightLabel.setLabelFor(this.inputM);
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(this.inputD);
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(this.inputM);
        panel.add(widthPanel);
        panel.add(heightPanel);
        panel.setSize(panel.getPreferredSize());
        ActionListener al = ae -> this.checkFields();
        this.inputD.addActionListener(al);
        this.inputM.addActionListener(al);
        Object fake = null;
        List c = ParametersDialog.choices();
        c.add(new ChoiceItem<Object>(Messages.message("ok"), fake).okOption());
        c.add(new ChoiceItem<Object>(Messages.message("cancel"), fake).cancelOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, true, panel, null, c);
    }

    private void checkFields() {
        try {
            int d = Integer.parseInt(this.inputD.getText());
            if (d <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.inputD.setText(Integer.toString(4));
        }
        try {
            int m = Integer.parseInt(this.inputM.getText());
            if (m <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.inputM.setText(Integer.toString(12));
        }
    }

    @Override
    public Parameters getResponse() {
        Object value = this.getValue();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            this.checkFields();
            return new Parameters(Integer.parseInt(this.inputD.getText()), Integer.parseInt(this.inputM.getText()));
        }
        return null;
    }

    @Override
    public void requestFocus() {
        this.inputD.requestFocus();
    }
}

