/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.Transformer;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.changes.DiscoveredInputRecorder;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.cache.PersistentStateCache;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileProcessor;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.RegexBackedCSourceParser;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.util.CollectionUtils;

public class IncrementalNativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private static final Logger LOGGER = Logging.getLogger(IncrementalNativeCompiler.class);
    private final Compiler<T> delegateCompiler;
    private final boolean importsAreIncludes;
    private final TaskInternal task;
    private final FileSnapshotter fileSnapshotter;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final CompilationStateCacheFactory compilationStateCacheFactory;
    private final CSourceParser sourceParser = new RegexBackedCSourceParser();

    public IncrementalNativeCompiler(TaskInternal task, FileSnapshotter fileSnapshotter, CompilationStateCacheFactory compilationStateCacheFactory, Compiler<T> delegateCompiler, NativeToolChain toolChain, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.task = task;
        this.fileSnapshotter = fileSnapshotter;
        this.compilationStateCacheFactory = compilationStateCacheFactory;
        this.delegateCompiler = delegateCompiler;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.importsAreIncludes = Clang.class.isAssignableFrom(toolChain.getClass()) || Gcc.class.isAssignableFrom(toolChain.getClass());
    }

    public WorkResult execute(T spec) {
        PersistentStateCache<CompilationState> compileStateCache = this.compilationStateCacheFactory.create(this.task.getPath());
        DefaultSourceIncludesParser sourceIncludesParser = new DefaultSourceIncludesParser(this.sourceParser, this.importsAreIncludes);
        IncrementalCompileProcessor processor = this.createProcessor(compileStateCache, sourceIncludesParser, spec.getIncludeRoots());
        IncrementalCompilation compilation = processor.processSourceFiles(spec.getSourceFiles());
        spec.setSourceFileIncludeDirectives(this.mapIncludes(spec.getSourceFiles(), compilation.getFinalState()));
        this.handleDiscoveredInputs(spec, compilation, spec.getDiscoveredInputRecorder());
        WorkResult workResult = spec.isIncrementalCompile() ? this.doIncrementalCompile(compilation, spec) : this.doCleanIncrementalCompile(spec);
        compileStateCache.set((Object)compilation.getFinalState());
        return workResult;
    }

    protected void handleDiscoveredInputs(T spec, IncrementalCompilation compilation, final DiscoveredInputRecorder discoveredInputRecorder) {
        for (File includeFile : compilation.getDiscoveredInputs()) {
            discoveredInputRecorder.newInput(includeFile);
        }
        if (this.sourceFilesUseMacroIncludes(spec.getSourceFiles(), compilation.getFinalState())) {
            LOGGER.info("After parsing the source files, Gradle cannot calculate the exact set of include files for {}. Every file in the include search path will be considered an input.", (Object)this.task.getName());
            for (File includeRoot : spec.getIncludeRoots()) {
                LOGGER.info("adding files in {} to discovered inputs for {}", (Object)includeRoot, (Object)this.task.getName());
                this.directoryFileTreeFactory.create(includeRoot).visit((FileVisitor)new EmptyFileVisitor(){

                    public void visitFile(FileVisitDetails fileDetails) {
                        discoveredInputRecorder.newInput(fileDetails.getFile());
                    }
                });
            }
        }
    }

    private Map<File, IncludeDirectives> mapIncludes(Collection<File> files, final CompilationState compilationState) {
        return CollectionUtils.collectMapValues(files, (Transformer)new Transformer<IncludeDirectives, File>(){

            public IncludeDirectives transform(File file) {
                return compilationState.getState(file).getIncludeDirectives();
            }
        });
    }

    private boolean sourceFilesUseMacroIncludes(Collection<File> files, final CompilationState compilationState) {
        return CollectionUtils.any(files, (Spec)new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                return CollectionUtils.any(compilationState.getState(file).getResolvedIncludes(), (Spec)new Spec<ResolvedInclude>(){

                    public boolean isSatisfiedBy(ResolvedInclude element) {
                        return element.isMaybeMacro();
                    }
                });
            }
        });
    }

    protected WorkResult doIncrementalCompile(IncrementalCompilation compilation, T spec) {
        spec.setSourceFiles(compilation.getRecompile());
        spec.setRemovedSourceFiles(compilation.getRemoved());
        return this.delegateCompiler.execute(spec);
    }

    protected WorkResult doCleanIncrementalCompile(T spec) {
        boolean deleted = this.cleanPreviousOutputs((NativeCompileSpec)spec);
        WorkResult compileResult = this.delegateCompiler.execute(spec);
        if (deleted && !compileResult.getDidWork()) {
            return new SimpleWorkResult(deleted);
        }
        return compileResult;
    }

    private boolean cleanPreviousOutputs(NativeCompileSpec spec) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getTask().getOutputs());
        cleaner.setDestinationDir(spec.getObjectFileDir());
        cleaner.execute();
        return cleaner.getDidWork();
    }

    protected TaskInternal getTask() {
        return this.task;
    }

    private IncrementalCompileProcessor createProcessor(PersistentStateCache<CompilationState> compileStateCache, SourceIncludesParser sourceIncludesParser, Iterable<File> includes) {
        DefaultSourceIncludesResolver dependencyParser = new DefaultSourceIncludesResolver(CollectionUtils.toList(includes));
        return new IncrementalCompileProcessor(compileStateCache, dependencyParser, sourceIncludesParser, this.fileSnapshotter);
    }
}

