/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.ReflectionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0007\u0010\tR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ReflectionAPICallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "isReflectionAvailable", "", "()Z", "isReflectionAvailable$delegate", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "kPropertyClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getKPropertyClasses", "()Ljava/util/Set;", "kPropertyClasses$delegate", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isReflectionSource", "kotlin-compiler"})
public final class ReflectionAPICallChecker
implements CallChecker {
    private final NotNullLazyValue isReflectionAvailable$delegate;
    private final NotNullLazyValue kPropertyClasses$delegate;
    private final ModuleDescriptor module;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final boolean isReflectionAvailable() {
        return (Boolean)StorageKt.getValue(this.isReflectionAvailable$delegate, (Object)this, $$delegatedProperties[0]);
    }

    private final Set<ClassDescriptor> getKPropertyClasses() {
        return (Set)StorageKt.getValue(this.kPropertyClasses$delegate, (Object)this, $$delegatedProperties[1]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (this.isReflectionAvailable()) {
            return;
        }
        if (this.isReflectionSource(reportOn)) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (!ReflectionTypes.Companion.isReflectionClass(containingClass)) {
            return;
        }
        Name name = descriptor2.getName();
        if (Intrinsics.areEqual(name, OperatorNameConventions.INVOKE)) {
            return;
        }
        if (Intrinsics.areEqual(name.asString(), "name")) {
            return;
        }
        if (Intrinsics.areEqual(name.asString(), "get") || Intrinsics.areEqual(name.asString(), "set")) {
            boolean bl;
            block10: {
                void $receiver$iv;
                Iterable iterable = this.getKPropertyClasses();
                for (Object element$iv : $receiver$iv) {
                    ClassDescriptor kProperty = (ClassDescriptor)element$iv;
                    if (!DescriptorUtils.isSubclass(containingClass, kProperty)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        context.getTrace().report(ErrorsJvm.NO_REFLECTION_IN_CLASS_PATH.on(reportOn));
    }

    private final boolean isReflectionSource(PsiElement reportOn) {
        PsiFile psiFile = reportOn.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return false;
        }
        KtFile file2 = ktFile;
        FqNameUnsafe fqName2 = file2.getPackageFqName().toUnsafe();
        return fqName2.startsWith(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME) && (Intrinsics.areEqual(fqName2, ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().toUnsafe()) || StringsKt.startsWith$default(fqName2.asString(), ReflectionTypesKt.getKOTLIN_REFLECT_FQ_NAME().asString() + ".", false, 2, null));
    }

    public ReflectionAPICallChecker(@NotNull ModuleDescriptor module, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        this.module = module;
        this.isReflectionAvailable$delegate = storageManager.createLazyValue((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ReflectionAPICallChecker this$0;

            public final boolean invoke() {
                ModuleDescriptor moduleDescriptor = ReflectionAPICallChecker.access$getModule$p(this.this$0);
                ClassId classId = JvmAbi.REFLECTION_FACTORY_IMPL;
                Intrinsics.checkExpressionValueIsNotNull(classId, "JvmAbi.REFLECTION_FACTORY_IMPL");
                return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId) != null;
            }
            {
                this.this$0 = reflectionAPICallChecker;
                super(0);
            }
        });
        this.kPropertyClasses$delegate = storageManager.createLazyValue((Function0)new Function0<Set<? extends ClassDescriptor>>(this){
            final /* synthetic */ ReflectionAPICallChecker this$0;

            @NotNull
            public final Set<ClassDescriptor> invoke() {
                ReflectionTypes reflectionTypes = new ReflectionTypes(ReflectionAPICallChecker.access$getModule$p(this.this$0));
                return SetsKt.setOf(new ClassDescriptor[]{reflectionTypes.getKProperty0(), reflectionTypes.getKProperty1(), reflectionTypes.getKProperty2()});
            }
            {
                this.this$0 = reflectionAPICallChecker;
                super(0);
            }
        });
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(ReflectionAPICallChecker.class), "isReflectionAvailable", "isReflectionAvailable()Z")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(ReflectionAPICallChecker.class), "kPropertyClasses", "getKPropertyClasses()Ljava/util/Set;"))};
    }

    @NotNull
    public static final /* synthetic */ ModuleDescriptor access$getModule$p(ReflectionAPICallChecker $this) {
        return $this.module;
    }
}

