/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.play.internal.run.DefaultPlayRunSpec;
import org.gradle.play.internal.run.PlayApplicationDeploymentHandle;
import org.gradle.play.internal.run.PlayApplicationRunner;
import org.gradle.play.internal.run.PlayApplicationRunnerToken;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class PlayRun
extends ConventionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayRun.class);
    private int httpPort;
    @InputFile
    private File applicationJar;
    @InputFile
    private File assetsJar;
    @InputFiles
    private Set<File> assetsDirs;
    @Classpath
    private FileCollection runtimeClasspath;
    @Classpath
    private FileCollection changingClasspath;
    private BaseForkOptions forkOptions;
    private PlayToolProvider playToolProvider;

    @Nested
    public BaseForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new BaseForkOptions();
        }
        return this.forkOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void run() {
        ProgressLogger progressLogger;
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)this.getServices().get(ProgressLoggerFactory.class);
        PlayApplicationDeploymentHandle deploymentHandle = this.registerOrFindDeploymentHandle(this.getPath());
        if (!deploymentHandle.isRunning()) {
            progressLogger = progressLoggerFactory.newOperation(PlayRun.class).start("Start Play server", "Starting Play");
            try {
                int httpPort = this.getHttpPort();
                DefaultPlayRunSpec spec = new DefaultPlayRunSpec((Iterable<File>)this.runtimeClasspath, (Iterable<File>)this.changingClasspath, this.applicationJar, this.assetsJar, this.assetsDirs, this.getProject().getProjectDir(), this.getForkOptions(), httpPort);
                PlayApplicationRunnerToken runnerToken = ((PlayApplicationRunner)this.playToolProvider.get(PlayApplicationRunner.class)).start(spec);
                deploymentHandle.start(runnerToken);
            }
            finally {
                progressLogger.completed();
            }
        }
        if (!this.getProject().getGradle().getStartParameter().isContinuous()) {
            progressLogger = progressLoggerFactory.newOperation(PlayRun.class).start("Run Play App at http://localhost:" + this.httpPort + "/", "Running at http://localhost:" + this.httpPort + "/");
            try {
                this.waitForCtrlD();
            }
            finally {
                progressLogger.completed();
            }
        } else {
            LOGGER.warn("Running Play App ({}) at http://localhost:{}/", (Object)this.getPath(), (Object)this.httpPort);
        }
    }

    private void waitForCtrlD() {
        try {
            int c;
            while ((c = System.in.read()) != -1 && c != 4) {
            }
            LOGGER.info("received end of stream (ctrl+d)");
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Internal
    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public File getApplicationJar() {
        return this.applicationJar;
    }

    public void setApplicationJar(File applicationJar) {
        this.applicationJar = applicationJar;
    }

    public File getAssetsJar() {
        return this.assetsJar;
    }

    public void setAssetsJar(File assetsJar) {
        this.assetsJar = assetsJar;
    }

    public Set<File> getAssetsDirs() {
        return this.assetsDirs;
    }

    public void setAssetsDirs(Set<File> assetsDirs) {
        this.assetsDirs = assetsDirs;
    }

    public void setRuntimeClasspath(FileCollection runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
    }

    public void setChangingClasspath(FileCollection changingClasspath) {
        this.changingClasspath = changingClasspath;
    }

    public void setPlayToolProvider(PlayToolProvider playToolProvider) {
        this.playToolProvider = playToolProvider;
    }

    @Inject
    public DeploymentRegistry getDeploymentRegistry() {
        throw new UnsupportedOperationException();
    }

    private PlayApplicationDeploymentHandle registerOrFindDeploymentHandle(String deploymentId) {
        DeploymentRegistry deploymentRegistry = this.getDeploymentRegistry();
        PlayApplicationDeploymentHandle deploymentHandle = (PlayApplicationDeploymentHandle)deploymentRegistry.get(PlayApplicationDeploymentHandle.class, deploymentId);
        if (deploymentHandle == null) {
            deploymentHandle = new PlayApplicationDeploymentHandle(deploymentId);
            deploymentRegistry.register(deploymentId, (DeploymentHandle)deploymentHandle);
        }
        return deploymentHandle;
    }
}

