/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.awt;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePoint {
    private Component myComponent;
    private Point myPointOnComponent;
    private Component myOriginalComponent;
    private Point myOriginalPoint;

    public RelativePoint(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/awt/RelativePoint", "<init>"));
        }
        this.init(event.getComponent(), event.getPoint());
        this.myOriginalComponent = event.getComponent();
        this.myOriginalPoint = event.getPoint();
    }

    public RelativePoint(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aComponent", "com/intellij/ui/awt/RelativePoint", "<init>"));
        }
        this.init(aComponent, aPointOnComponent);
    }

    public RelativePoint(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "screenPoint", "com/intellij/ui/awt/RelativePoint", "<init>"));
        }
        Point p = new Point(screenPoint.x, screenPoint.y);
        Window[] windows = Window.getWindows();
        Window targetWindow = null;
        for (Window each : windows) {
            if (!each.isActive()) continue;
            targetWindow = each;
            break;
        }
        if (targetWindow == null) {
            targetWindow = JOptionPane.getRootFrame();
        }
        SwingUtilities.convertPointFromScreen(p, targetWindow);
        this.init(targetWindow, p);
    }

    private void init(@NotNull Component aComponent, Point aPointOnComponent) {
        if (aComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aComponent", "com/intellij/ui/awt/RelativePoint", "init"));
        }
        if (aComponent.isShowing()) {
            this.myComponent = SwingUtilities.getRootPane(aComponent);
            this.myPointOnComponent = SwingUtilities.convertPoint(aComponent, aPointOnComponent, this.myComponent);
        } else {
            this.myComponent = aComponent;
            this.myPointOnComponent = aPointOnComponent;
        }
        this.myOriginalComponent = this.myComponent;
        this.myOriginalPoint = this.myPointOnComponent;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public Point getPoint() {
        return this.myPointOnComponent;
    }

    public Point getPoint(@Nullable Component aTargetComponent) {
        boolean window = aTargetComponent instanceof Window;
        if (aTargetComponent == null || !window && (aTargetComponent.getParent() == null || SwingUtilities.getWindowAncestor(aTargetComponent) == null)) {
            return new Point();
        }
        return SwingUtilities.convertPoint(this.getComponent(), this.getPoint(), aTargetComponent);
    }

    @NotNull
    public RelativePoint getPointOn(@NotNull Component aTargetComponent) {
        if (aTargetComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aTargetComponent", "com/intellij/ui/awt/RelativePoint", "getPointOn"));
        }
        Point point = this.getPoint(aTargetComponent);
        RelativePoint relativePoint = new RelativePoint(aTargetComponent, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getPointOn"));
        }
        return relativePoint;
    }

    @NotNull
    public Point getScreenPoint() {
        Point point = (Point)this.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, this.getComponent());
        Point point2 = point;
        if (point2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getScreenPoint"));
        }
        return point2;
    }

    @NotNull
    public MouseEvent toMouseEvent() {
        MouseEvent mouseEvent = new MouseEvent(this.myComponent, 0, 0L, 0, this.myPointOnComponent.x, this.myPointOnComponent.y, 1, false);
        if (mouseEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "toMouseEvent"));
        }
        return mouseEvent;
    }

    @NotNull
    public String toString() {
        String string = this.getPoint() + " on " + this.getComponent().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "toString"));
        }
        return string;
    }

    @NotNull
    public static RelativePoint getCenterOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/awt/RelativePoint", "getCenterOf"));
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getCenterOf"));
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthEastOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/awt/RelativePoint", "getSouthEastOf"));
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getSouthEastOf"));
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthWestOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/awt/RelativePoint", "getSouthWestOf"));
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getSouthWestOf"));
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getSouthOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/awt/RelativePoint", "getSouthOf"));
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getSouthOf"));
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthWestOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/awt/RelativePoint", "getNorthWestOf"));
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getNorthWestOf"));
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getNorthEastOf(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/awt/RelativePoint", "getNorthEastOf"));
        }
        Rectangle visibleRect = component.getVisibleRect();
        Point point = new Point(visibleRect.x + visibleRect.width, visibleRect.y);
        RelativePoint relativePoint = new RelativePoint(component, point);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "getNorthEastOf"));
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint fromScreen(Point screenPoint) {
        Frame root = JOptionPane.getRootFrame();
        SwingUtilities.convertPointFromScreen(screenPoint, root);
        RelativePoint relativePoint = new RelativePoint(root, screenPoint);
        if (relativePoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/awt/RelativePoint", "fromScreen"));
        }
        return relativePoint;
    }

    public Component getOriginalComponent() {
        return this.myOriginalComponent;
    }

    public Point getOriginalPoint() {
        return this.myOriginalPoint;
    }
}

