/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;

public class Range<T extends Comparable<T>> {
    private final T myFrom;
    private final T myTo;

    public Range(@NotNull T from, @NotNull T to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/util/Range", "<init>"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/Range", "<init>"));
        }
        this.myFrom = from;
        this.myTo = to;
    }

    public boolean isWithin(T object) {
        return object.compareTo(this.myFrom) >= 0 && object.compareTo(this.myTo) <= 0;
    }

    public T getFrom() {
        return this.myFrom;
    }

    public T getTo() {
        return this.myTo;
    }

    public String toString() {
        return "(" + this.myFrom + "," + this.myTo + ")";
    }
}

