/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.AppleHiDPIScaledImage;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class RetinaImage {
    public static Image createFrom(Image image) {
        return RetinaImage.createFrom(image, 2, ImageLoader.ourComponent);
    }

    public static Image createFrom(Image image, int scale, ImageObserver observer) {
        int w = image.getWidth(observer);
        int h = image.getHeight(observer);
        BufferedImage hidpi = RetinaImage.create(image, w / scale, h / scale, 2);
        if (SystemInfo.isAppleJvm) {
            Graphics2D g = (Graphics2D)((Image)hidpi).getGraphics();
            g.scale(1.0f / (float)scale, 1.0f / (float)scale);
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        return hidpi;
    }

    public static BufferedImage create(int width, int height, int type) {
        return RetinaImage.create(null, width, height, type);
    }

    private static BufferedImage create(Image image, int width, int height, int type) {
        if (SystemInfo.isAppleJvm) {
            return AppleHiDPIScaledImage.create(width, height, type);
        }
        if (image == null) {
            return new JBHiDPIScaledImage(width, height, type);
        }
        return new JBHiDPIScaledImage(image, width, height, type);
    }

    public static boolean isAppleHiDPIScaledImage(Image image) {
        return UIUtil.isAppleRetina() && AppleHiDPIScaledImage.is(image);
    }
}

