/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.SkipEmptySerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import gnu.trove.TObjectFloatHashMap;
import java.util.LinkedHashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class SmartSerializer {
    private LinkedHashSet<String> mySerializedAccessorNameTracker;
    private TObjectFloatHashMap<String> myOrderedBindings;
    private final SerializationFilter mySerializationFilter;

    public SmartSerializer(boolean trackSerializedNames, boolean useSkipEmptySerializationFilter) {
        this.mySerializedAccessorNameTracker = trackSerializedNames ? new LinkedHashSet() : null;
        this.mySerializationFilter = useSkipEmptySerializationFilter ? new SkipEmptySerializationFilter(){

            @Override
            protected ThreeState accepts(@NotNull String name, @NotNull Object beanValue) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/xmlb/SmartSerializer$1", "accepts"));
                }
                if (beanValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanValue", "com/intellij/util/xmlb/SmartSerializer$1", "accepts"));
                }
                return SmartSerializer.this.mySerializedAccessorNameTracker != null && SmartSerializer.this.mySerializedAccessorNameTracker.contains(name) ? ThreeState.YES : ThreeState.UNSURE;
            }
        } : new SkipDefaultValuesSerializationFilters(){

            @Override
            public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
                if (accessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/SmartSerializer$2", "accepts"));
                }
                if (bean == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SmartSerializer$2", "accepts"));
                }
                if (SmartSerializer.this.mySerializedAccessorNameTracker != null && SmartSerializer.this.mySerializedAccessorNameTracker.contains(accessor.getName())) {
                    return true;
                }
                return super.accepts(accessor, bean);
            }
        };
    }

    public SmartSerializer() {
        this(true, false);
    }

    @NotNull
    public static SmartSerializer skipEmptySerializer() {
        SmartSerializer smartSerializer = new SmartSerializer(true, true);
        if (smartSerializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/SmartSerializer", "skipEmptySerializer"));
        }
        return smartSerializer;
    }

    public void readExternal(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SmartSerializer", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/SmartSerializer", "readExternal"));
        }
        if (this.mySerializedAccessorNameTracker != null) {
            this.mySerializedAccessorNameTracker.clear();
            this.myOrderedBindings = null;
        }
        BeanBinding beanBinding = SmartSerializer.getBinding(bean);
        beanBinding.deserializeInto(bean, element, this.mySerializedAccessorNameTracker);
        if (this.mySerializedAccessorNameTracker != null) {
            this.myOrderedBindings = beanBinding.computeBindingWeights(this.mySerializedAccessorNameTracker);
        }
    }

    public void writeExternal(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SmartSerializer", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/SmartSerializer", "writeExternal"));
        }
        this.writeExternal(bean, element, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Object bean, @NotNull Element element, boolean preserveCompatibility) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SmartSerializer", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/SmartSerializer", "writeExternal"));
        }
        BeanBinding binding = SmartSerializer.getBinding(bean);
        if (preserveCompatibility && this.myOrderedBindings != null) {
            binding.sortBindings(this.myOrderedBindings);
        }
        if (preserveCompatibility || this.mySerializedAccessorNameTracker == null) {
            binding.serializeInto(bean, element, this.mySerializationFilter);
        } else {
            LinkedHashSet<String> oldTracker = this.mySerializedAccessorNameTracker;
            try {
                this.mySerializedAccessorNameTracker = null;
                binding.serializeInto(bean, element, this.mySerializationFilter);
            }
            finally {
                this.mySerializedAccessorNameTracker = oldTracker;
            }
        }
    }

    @NotNull
    private static BeanBinding getBinding(@NotNull Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SmartSerializer", "getBinding"));
        }
        BeanBinding beanBinding = (BeanBinding)XmlSerializerImpl.getBinding(bean.getClass());
        if (beanBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/SmartSerializer", "getBinding"));
        }
        return beanBinding;
    }
}

