/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "Companion"})
public final class ReferenceLinkParser
implements SequentialParser {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        TokensCache.Iterator iterator = tokens.new TokensCache.ListIterator(indices, 0);
        while (iterator.getType() != null) {
            LocalParsingResult referenceLink;
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.LBRACKET) && (referenceLink = Companion.parseReferenceLink(iterator)) != null) {
                iterator = referenceLink.getIteratorPosition().advance();
                result = result.withOtherParsingResult(referenceLink);
                continue;
            }
            delegateIndices.add(iterator.getIndex());
            iterator = iterator.advance();
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<Integer>)delegateIndices));
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007H\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007J\u0016\u0010\t\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007H\u0002"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ReferenceLinkParser$Companion;", "", "()V", "parseFullReferenceLink", "Lorg/intellij/markdown/parser/sequentialparsers/LocalParsingResult;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "parseReferenceLink", "parseShortReferenceLink"})
    public static final class Companion {
        @Nullable
        public final LocalParsingResult parseReferenceLink(@NotNull TokensCache.Iterator iterator) {
            Intrinsics.checkParameterIsNotNull((Object)iterator, (String)"iterator");
            LocalParsingResult localParsingResult = this.parseFullReferenceLink(iterator);
            if (localParsingResult == null) {
                localParsingResult = this.parseShortReferenceLink(iterator);
            }
            return localParsingResult;
        }

        private final LocalParsingResult parseFullReferenceLink(TokensCache.Iterator iterator) {
            int startIndex = iterator.getIndex();
            LocalParsingResult localParsingResult = LinkParserUtil.Companion.parseLinkText(iterator);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkText = localParsingResult;
            TokensCache.Iterator it = linkText.getIteratorPosition().advance();
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            LocalParsingResult localParsingResult2 = LinkParserUtil.Companion.parseLinkLabel(it);
            if (localParsingResult2 == null) {
                return null;
            }
            LocalParsingResult linkLabel = localParsingResult2;
            it = linkLabel.getIteratorPosition();
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus((Collection)CollectionsKt.plus(linkText.getParsedNodes(), (Iterable)linkLabel.getParsedNodes()), (Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.FULL_REFERENCE_LINK)), CollectionsKt.plus(linkText.getRangesToProcessFurther(), (Iterable)linkLabel.getRangesToProcessFurther()));
        }

        private final LocalParsingResult parseShortReferenceLink(TokensCache.Iterator iterator) {
            TokensCache.Iterator it;
            int startIndex = iterator.getIndex();
            LocalParsingResult localParsingResult = LinkParserUtil.Companion.parseLinkLabel(iterator);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkLabel = localParsingResult;
            TokensCache.Iterator shortcutLinkEnd = it = linkLabel.getIteratorPosition();
            it = it.advance();
            if (Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            it = Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.LBRACKET) && Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.RBRACKET) ? it.advance() : shortcutLinkEnd;
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus(linkLabel.getParsedNodes(), (Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.SHORT_REFERENCE_LINK)), linkLabel.getRangesToProcessFurther());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

