/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;

public class BuildOutputConsumerImpl
implements BuildOutputConsumer {
    private static final Logger LOG = Logger.getInstance(BuildOutputConsumerImpl.class);
    private final BuildTarget<?> myTarget;
    private final CompileContext myContext;
    private FileGeneratedEvent myFileGeneratedEvent;
    private Collection<File> myOutputs;
    private THashSet<String> myRegisteredSources = new THashSet(FileUtil.PATH_HASHING_STRATEGY);

    public BuildOutputConsumerImpl(BuildTarget<?> target, CompileContext context) {
        this.myTarget = target;
        this.myContext = context;
        this.myFileGeneratedEvent = new FileGeneratedEvent();
        this.myOutputs = this.myTarget.getOutputRoots(context);
    }

    private void registerOutput(File output, boolean isDirectory, Collection<String> sourcePaths) throws IOException {
        String outputPath = FileUtil.toSystemIndependentName((String)output.getPath());
        for (File outputRoot : this.myOutputs) {
            String outputRootPath = FileUtil.toSystemIndependentName((String)outputRoot.getPath());
            String relativePath = FileUtil.getRelativePath((String)outputRootPath, (String)outputPath, (char)'/');
            if (relativePath == null || relativePath.startsWith("../")) continue;
            if (isDirectory) {
                this.addEventsRecursively(output, outputRootPath, relativePath);
                continue;
            }
            this.myFileGeneratedEvent.add(outputRootPath, relativePath);
        }
        SourceToOutputMapping mapping = this.myContext.getProjectDescriptor().dataManager.getSourceToOutputMap(this.myTarget);
        for (String sourcePath : sourcePaths) {
            if (this.myRegisteredSources.add((Object)FileUtil.toSystemIndependentName((String)sourcePath))) {
                mapping.setOutput(sourcePath, outputPath);
                continue;
            }
            mapping.appendOutput(sourcePath, outputPath);
        }
    }

    private void addEventsRecursively(File output, String outputRootPath, String relativePath) {
        File[] children = output.listFiles();
        if (children == null) {
            this.myFileGeneratedEvent.add(outputRootPath, relativePath);
        } else {
            String prefix = relativePath.isEmpty() || relativePath.equals(".") ? "" : relativePath + "/";
            for (File child : children) {
                this.addEventsRecursively(child, outputRootPath, prefix + child.getName());
            }
        }
    }

    @Override
    public void registerOutputFile(@NotNull File outputFile, @NotNull Collection<String> sourcePaths) throws IOException {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/jps/builders/impl/BuildOutputConsumerImpl", "registerOutputFile"));
        }
        if (sourcePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePaths", "org/jetbrains/jps/builders/impl/BuildOutputConsumerImpl", "registerOutputFile"));
        }
        this.registerOutput(outputFile, false, sourcePaths);
    }

    @Override
    public void registerOutputDirectory(@NotNull File outputDir, @NotNull Collection<String> sourcePaths) throws IOException {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/jps/builders/impl/BuildOutputConsumerImpl", "registerOutputDirectory"));
        }
        if (sourcePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePaths", "org/jetbrains/jps/builders/impl/BuildOutputConsumerImpl", "registerOutputDirectory"));
        }
        LOG.assertTrue(!(this.myTarget instanceof ModuleBuildTarget) && !(this.myTarget instanceof ArtifactBuildTarget), (Object)("'registerOutputDirectory' method cannot be used for target " + this.myTarget + ", it will break incremental compilation"));
        this.registerOutput(outputDir, true, sourcePaths);
    }

    public int getNumberOfProcessedSources() {
        return this.myRegisteredSources.size();
    }

    public void fireFileGeneratedEvent() {
        if (!this.myFileGeneratedEvent.getPaths().isEmpty()) {
            this.myContext.processMessage(this.myFileGeneratedEvent);
        }
    }
}

