/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex.indexer.impl;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class EnumeratedMethodIncompleteSignature {
    private final int myOwner;
    private final int myName;
    private final boolean myStatic;

    public EnumeratedMethodIncompleteSignature(int owner, int name, boolean aStatic) {
        this.myOwner = owner;
        this.myName = name;
        this.myStatic = aStatic;
    }

    public int getOwner() {
        return this.myOwner;
    }

    public int getName() {
        return this.myName;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public static DataExternalizer<EnumeratedMethodIncompleteSignature> createDataExternalizer() {
        return new DataExternalizer<EnumeratedMethodIncompleteSignature>(){

            public void save(@NotNull DataOutput out, EnumeratedMethodIncompleteSignature value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/classFilesIndex/indexer/impl/EnumeratedMethodIncompleteSignature$1", "save"));
                }
                out.writeInt(value.getOwner());
                out.writeInt(value.getName());
                out.writeBoolean(value.isStatic());
            }

            public EnumeratedMethodIncompleteSignature read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/classFilesIndex/indexer/impl/EnumeratedMethodIncompleteSignature$1", "read"));
                }
                return new EnumeratedMethodIncompleteSignature(in.readInt(), in.readInt(), in.readBoolean());
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumeratedMethodIncompleteSignature that = (EnumeratedMethodIncompleteSignature)o;
        if (this.myName != that.myName) {
            return false;
        }
        if (this.myOwner != that.myOwner) {
            return false;
        }
        return this.myStatic == that.myStatic;
    }

    public int hashCode() {
        int result = this.myOwner;
        result = 31 * result + this.myName;
        result = 31 * result + (this.myStatic ? 1 : 0);
        return result;
    }
}

