/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.IOUtil;
import gnu.trove.TObjectLongHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.fs.FilesDelta;
import org.jetbrains.jps.incremental.storage.Timestamps;
import org.jetbrains.jps.model.JpsModel;

public class BuildFSState {
    public static final int VERSION = 3;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.fs.BuildFSState");
    private static final Key<Set<? extends BuildTarget<?>>> CONTEXT_TARGETS_KEY = Key.create((String)"_fssfate_context_targets_");
    private static final Key<FilesDelta> NEXT_ROUND_DELTA_KEY = Key.create((String)"_next_round_delta_");
    private static final Key<FilesDelta> CURRENT_ROUND_DELTA_KEY = Key.create((String)"_current_round_delta_");
    private final boolean myAlwaysScanFS;
    private final Set<BuildTarget<?>> myInitialScanPerformed = Collections.synchronizedSet(new HashSet());
    private final TObjectLongHashMap<File> myRegistrationStamps = new TObjectLongHashMap(FileUtil.FILE_HASHING_STRATEGY);
    private final Map<BuildTarget<?>, FilesDelta> myDeltas = Collections.synchronizedMap(new HashMap());

    public BuildFSState(boolean alwaysScanFS) {
        this.myAlwaysScanFS = alwaysScanFS;
    }

    public void save(DataOutput out) throws IOException {
        MultiMap targetsByType = new MultiMap();
        for (BuildTarget<?> target : this.myInitialScanPerformed) {
            targetsByType.putValue(target.getTargetType(), target);
        }
        out.writeInt(targetsByType.size());
        for (BuildTargetType type : targetsByType.keySet()) {
            IOUtil.writeString((String)type.getTypeId(), (DataOutput)out);
            Collection targets = targetsByType.get((Object)type);
            out.writeInt(targets.size());
            for (BuildTarget target : targets) {
                IOUtil.writeString((String)target.getId(), (DataOutput)out);
                this.getDelta(target).save(out);
            }
        }
    }

    public void load(DataInputStream in, JpsModel model, BuildRootIndex buildRootIndex) throws IOException {
        TargetTypeRegistry registry = TargetTypeRegistry.getInstance();
        int typeCount = in.readInt();
        while (typeCount-- > 0) {
            BuildTargetLoader<?> loader;
            String typeId = IOUtil.readString((DataInput)in);
            int targetCount = in.readInt();
            BuildTargetType<?> type = registry.getTargetType(typeId);
            BuildTargetLoader<?> buildTargetLoader = loader = type != null ? type.createLoader(model) : null;
            while (targetCount-- > 0) {
                Object target;
                String id = IOUtil.readString((DataInput)in);
                boolean loaded = false;
                if (loader != null && (target = loader.createTarget(id)) != null) {
                    this.getDelta((BuildTarget<?>)target).load(in, (BuildTarget<?>)target, buildRootIndex);
                    this.myInitialScanPerformed.add((BuildTarget<?>)target);
                    loaded = true;
                }
                if (loaded) continue;
                LOG.info("Skipping unknown target (typeId=" + typeId + ", type=" + type + ", id=" + id + ")");
                FilesDelta.skip(in);
            }
        }
    }

    public final void clearRecompile(BuildRootDescriptor rd) {
        this.getDelta(rd.getTarget()).clearRecompile(rd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEventRegistrationStamp(File file) {
        TObjectLongHashMap<File> tObjectLongHashMap = this.myRegistrationStamps;
        synchronized (tObjectLongHashMap) {
            return this.myRegistrationStamps.get((Object)file);
        }
    }

    public boolean hasWorkToDo(BuildTarget<?> target) {
        if (!this.myInitialScanPerformed.contains(target)) {
            return true;
        }
        FilesDelta delta = this.myDeltas.get(target);
        return delta != null && delta.hasChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnprocessedChanges(@NotNull CompileContext context, @NotNull BuildTarget<?> target) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/fs/BuildFSState", "hasUnprocessedChanges"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/fs/BuildFSState", "hasUnprocessedChanges"));
        }
        if (!this.myInitialScanPerformed.contains(target)) {
            return false;
        }
        FilesDelta delta = this.myDeltas.get(target);
        if (delta == null) {
            return false;
        }
        long targetBuildStart = context.getCompilationStartStamp(target);
        if (targetBuildStart <= 0L) {
            return false;
        }
        CompileScope scope = context.getScope();
        BuildRootIndex rootIndex = context.getProjectDescriptor().getBuildRootIndex();
        try {
            delta.lockData();
            for (Set<File> files : delta.getSourcesToRecompile().values()) {
                block5: for (File file : files) {
                    if (this.getEventRegistrationStamp(file) <= targetBuildStart && FileSystemUtil.lastModified((File)file) <= targetBuildStart || !scope.isAffected(target, file)) continue;
                    for (BuildRootDescriptor rd : rootIndex.findAllParentDescriptors(file, context)) {
                        if (!rd.isGenerated()) continue;
                        continue block5;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unprocessed changes detected for target " + target + "; file: " + file.getPath() + "; targetBuildStart=" + targetBuildStart + "; eventRegistrationStamp=" + this.getEventRegistrationStamp(file) + "; lastModified=" + FileSystemUtil.lastModified((File)file));
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            delta.unlockData();
        }
        return false;
    }

    public void markInitialScanPerformed(BuildTarget<?> target) {
        this.myInitialScanPerformed.add(target);
    }

    public void registerDeleted(BuildTarget<?> target, File file, @Nullable Timestamps tsStorage) throws IOException {
        this.registerDeleted(target, file);
        if (tsStorage != null) {
            tsStorage.removeStamp(file, target);
        }
    }

    public void registerDeleted(BuildTarget<?> target, File file) {
        this.getDelta(target).addDeleted(file);
    }

    public void clearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            delta.clearDeletedPaths();
        }
    }

    public Collection<String> getAndClearDeletedPaths(BuildTarget<?> target) {
        FilesDelta delta = this.myDeltas.get(target);
        if (delta != null) {
            return delta.getAndClearDeletedPaths();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private FilesDelta getDelta(BuildTarget<?> buildTarget) {
        Map<BuildTarget<?>, FilesDelta> map = this.myDeltas;
        // MONITORENTER : map
        FilesDelta delta = this.myDeltas.get(buildTarget);
        if (delta == null) {
            delta = new FilesDelta();
            this.myDeltas.put(buildTarget, delta);
        }
        FilesDelta filesDelta = delta;
        // MONITOREXIT : map
        if (filesDelta != null) return filesDelta;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/fs/BuildFSState", "getDelta"));
    }

    public boolean isInitialScanPerformed(BuildTarget<?> target) {
        return !this.myAlwaysScanFS && this.myInitialScanPerformed.contains(target);
    }

    @NotNull
    public FilesDelta getEffectiveFilesDelta(@NotNull CompileContext context, BuildTarget<?> target) {
        FilesDelta lastRoundDelta;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/fs/BuildFSState", "getEffectiveFilesDelta"));
        }
        if (target instanceof ModuleBuildTarget && (lastRoundDelta = BuildFSState.getRoundDelta(CURRENT_ROUND_DELTA_KEY, context)) != null) {
            FilesDelta filesDelta = lastRoundDelta;
            if (filesDelta == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/fs/BuildFSState", "getEffectiveFilesDelta"));
            }
            return filesDelta;
        }
        FilesDelta filesDelta = this.getDelta(target);
        if (filesDelta == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/fs/BuildFSState", "getEffectiveFilesDelta"));
        }
        return filesDelta;
    }

    public boolean isMarkedForRecompilation(@Nullable CompileContext context, CompilationRound round, BuildRootDescriptor rd, File file) {
        FilesDelta delta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context);
        if (delta == null) {
            delta = this.getDelta(rd.getTarget());
        }
        return delta.isMarkedRecompile(rd, file);
    }

    public final boolean markDirty(@Nullable CompileContext context, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage, boolean saveEventStamp) throws IOException {
        return this.markDirty(context, CompilationRound.NEXT, file, rd, tsStorage, saveEventStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markDirty(@Nullable CompileContext context, CompilationRound round, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage, boolean saveEventStamp) throws IOException {
        FilesDelta roundDelta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context);
        if (roundDelta != null && BuildFSState.isInCurrentContextTargets(context, rd)) {
            roundDelta.markRecompile(rd, file);
        }
        FilesDelta filesDelta = this.getDelta(rd.getTarget());
        filesDelta.lockData();
        try {
            boolean marked = filesDelta.markRecompile(rd, file);
            if (marked) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(rd.getTarget() + ": MARKED DIRTY: " + file.getPath());
                }
                if (saveEventStamp) {
                    long eventStamp = System.currentTimeMillis();
                    TObjectLongHashMap<File> tObjectLongHashMap = this.myRegistrationStamps;
                    synchronized (tObjectLongHashMap) {
                        this.myRegistrationStamps.put((Object)file, eventStamp);
                    }
                }
                if (tsStorage != null) {
                    tsStorage.removeStamp(file, rd.getTarget());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(rd.getTarget() + ": NOT MARKED DIRTY: " + file.getPath());
            }
            boolean bl = marked;
            return bl;
        }
        finally {
            filesDelta.unlockData();
        }
    }

    private static boolean isInCurrentContextTargets(CompileContext context, BuildRootDescriptor rd) {
        if (context == null) {
            return false;
        }
        Set targets = (Set)CONTEXT_TARGETS_KEY.get((UserDataHolder)context, Collections.emptySet());
        return targets.contains(rd.getTarget());
    }

    public boolean markDirtyIfNotDeleted(@Nullable CompileContext context, CompilationRound round, File file, BuildRootDescriptor rd, @Nullable Timestamps tsStorage) throws IOException {
        FilesDelta roundDelta;
        boolean marked = this.getDelta(rd.getTarget()).markRecompileIfNotDeleted(rd, file);
        if (marked && tsStorage != null) {
            tsStorage.removeStamp(file, rd.getTarget());
        }
        if (marked && (roundDelta = BuildFSState.getRoundDelta(round == CompilationRound.NEXT ? NEXT_ROUND_DELTA_KEY : CURRENT_ROUND_DELTA_KEY, context)) != null && BuildFSState.isInCurrentContextTargets(context, rd)) {
            roundDelta.markRecompile(rd, file);
        }
        return marked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        this.clearContextRoundData(null);
        this.clearContextChunk(null);
        this.myInitialScanPerformed.clear();
        this.myDeltas.clear();
        TObjectLongHashMap<File> tObjectLongHashMap = this.myRegistrationStamps;
        synchronized (tObjectLongHashMap) {
            this.myRegistrationStamps.clear();
        }
    }

    public void clearContextRoundData(@Nullable CompileContext context) {
        BuildFSState.setRoundDelta(NEXT_ROUND_DELTA_KEY, context, null);
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, null);
    }

    public void clearContextChunk(@Nullable CompileContext context) {
        BuildFSState.setContextTargets(context, null);
    }

    public void beforeChunkBuildStart(@NotNull CompileContext context, BuildTargetChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/fs/BuildFSState", "beforeChunkBuildStart"));
        }
        BuildFSState.setContextTargets(context, chunk.getTargets());
    }

    public void beforeNextRoundStart(@NotNull CompileContext context, ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/fs/BuildFSState", "beforeNextRoundStart"));
        }
        FilesDelta currentDelta = BuildFSState.getRoundDelta(NEXT_ROUND_DELTA_KEY, context);
        if (currentDelta == null) {
            SmartList deltas = new SmartList();
            for (ModuleBuildTarget target : chunk.getTargets()) {
                deltas.add(this.getDelta(target));
            }
            currentDelta = new FilesDelta((Collection<FilesDelta>)deltas);
        }
        BuildFSState.setRoundDelta(CURRENT_ROUND_DELTA_KEY, context, currentDelta);
        BuildFSState.setRoundDelta(NEXT_ROUND_DELTA_KEY, context, new FilesDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BuildRootDescriptor, T extends BuildTarget<R>> boolean processFilesToRecompile(CompileContext context, @NotNull T target, FileProcessor<R, T> processor) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/fs/BuildFSState", "processFilesToRecompile"));
        }
        CompileScope scope = context.getScope();
        FilesDelta delta = this.getEffectiveFilesDelta(context, target);
        delta.lockData();
        try {
            for (Map.Entry<BuildRootDescriptor, Set<File>> entry : delta.getSourcesToRecompile().entrySet()) {
                BuildRootDescriptor root = entry.getKey();
                if (!target.equals(root.getTarget())) continue;
                for (File file : entry.getValue()) {
                    if (!scope.isAffected(target, file)) continue;
                    if (processor.apply(target, file, root)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            delta.unlockData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markAllUpToDate(CompileContext context, BuildRootDescriptor rd, Timestamps stamps) throws IOException {
        boolean marked = false;
        BuildTarget<?> target = rd.getTarget();
        FilesDelta delta = this.getDelta(target);
        long targetBuildStartStamp = context.getCompilationStartStamp(target);
        delta.lockData();
        try {
            Set<File> files = delta.clearRecompile(rd);
            if (files != null) {
                CompileScope scope = context.getScope();
                for (File file : files) {
                    if (scope.isAffected(target, file)) {
                        long currentFileStamp = FileSystemUtil.lastModified((File)file);
                        if (!(rd.isGenerated() || currentFileStamp <= targetBuildStartStamp && this.getEventRegistrationStamp(file) <= targetBuildStartStamp)) {
                            if (Utils.IS_TEST_MODE) {
                                LOG.info("Timestamp after compilation started; marking dirty again: " + file.getPath());
                            }
                            delta.markRecompile(rd, file);
                            continue;
                        }
                        marked = true;
                        stamps.saveStamp(file, target, currentFileStamp);
                        continue;
                    }
                    if (Utils.IS_TEST_MODE) {
                        LOG.info("Not affected by compile scope; marking dirty again: " + file.getPath());
                    }
                    delta.markRecompile(rd, file);
                }
            }
            boolean bl = marked;
            return bl;
        }
        finally {
            delta.unlockData();
        }
    }

    private static void setContextTargets(@Nullable CompileContext context, @Nullable Set<? extends BuildTarget<?>> targets) {
        if (context != null) {
            CONTEXT_TARGETS_KEY.set((UserDataHolder)context, targets);
        }
    }

    @Nullable
    private static FilesDelta getRoundDelta(@NotNull Key<FilesDelta> key, @Nullable CompileContext context) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jps/incremental/fs/BuildFSState", "getRoundDelta"));
        }
        return context != null ? (FilesDelta)key.get((UserDataHolder)context) : null;
    }

    private static void setRoundDelta(@NotNull Key<FilesDelta> key, @Nullable CompileContext context, @Nullable FilesDelta delta) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/jps/incremental/fs/BuildFSState", "setRoundDelta"));
        }
        if (context != null) {
            key.set((UserDataHolder)context, (Object)delta);
        }
    }
}

