/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.http;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.http.GitAskPassXmlRpcClient;

public class GitAskPassApp
implements GitExternalApp {
    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("No arguments specified!");
            }
            Pair<Boolean, String> arguments = GitAskPassApp.parseArguments(args[0]);
            boolean usernameNeeded = (Boolean)arguments.getFirst();
            String url = (String)arguments.getSecond();
            String token = GitAskPassApp.getNotNull("GIT_ASKPASS_HANDLER");
            int xmlRpcPort = Integer.parseInt(GitAskPassApp.getNotNull("GIT_ASKPASS_PORT"));
            GitAskPassXmlRpcClient xmlRpcClient = new GitAskPassXmlRpcClient(xmlRpcPort);
            if (usernameNeeded) {
                String username = xmlRpcClient.askUsername(token, url);
                System.out.println(username);
            } else {
                String pass = xmlRpcClient.askPassword(token, url);
                System.out.println(pass);
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    private static String getNotNull(@NotNull String env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/git4idea/http/GitAskPassApp", "getNotNull"));
        }
        String value = System.getenv(env);
        if (value == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/git4idea/http/GitAskPassApp", "getNotNull"));
        }
        return string;
    }

    @NotNull
    private static Pair<Boolean, String> parseArguments(@NotNull String arg) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "org/jetbrains/git4idea/http/GitAskPassApp", "parseArguments"));
        }
        boolean username = StringUtilRt.startsWithIgnoreCase((String)arg, (String)"username");
        String[] split = arg.split(" ");
        String url = split.length > 2 ? GitAskPassApp.parseUrl(split[2]) : "";
        Pair pair = Pair.create((Object)username, (Object)url);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/git4idea/http/GitAskPassApp", "parseArguments"));
        }
        return pair;
    }

    private static String parseUrl(@NotNull String urlArg) {
        if (urlArg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlArg", "org/jetbrains/git4idea/http/GitAskPassApp", "parseUrl"));
        }
        String url = urlArg;
        if (url.startsWith("'")) {
            url = url.substring(1);
        }
        if (url.endsWith(":")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("'")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

