/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.logging.BuildOperationLogInfo;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.internal.operations.logging.DefaultBuildOperationLogger;
import org.gradle.util.GFileUtils;

public class DefaultBuildOperationLoggerFactory
implements BuildOperationLoggerFactory {
    private static final int MAX_FAILURES = 10;
    private final Logger logger;

    DefaultBuildOperationLoggerFactory(Logger logger) {
        this.logger = logger;
    }

    public DefaultBuildOperationLoggerFactory() {
        this(Logging.getLogger(DefaultBuildOperationLoggerFactory.class));
    }

    public BuildOperationLogger newOperationLogger(String taskName, File outputDir) {
        File outputFile = this.createOutputFile(outputDir);
        PrintWriter logWriter = this.createWriter(outputFile);
        BuildOperationLogInfo configuration = this.createLogInfo(taskName, outputFile, 10);
        return new DefaultBuildOperationLogger(configuration, this.logger, logWriter);
    }

    protected File createOutputFile(File outputDir) {
        GFileUtils.mkdirs(outputDir);
        return new File(outputDir, "output.txt");
    }

    protected PrintWriter createWriter(File outputFile) {
        PrintWriter logWriter = null;
        try {
            logWriter = new PrintWriter((Writer)new FileWriter(outputFile), true);
        }
        catch (IOException e) {
            UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return logWriter;
    }

    protected BuildOperationLogInfo createLogInfo(String taskName, File outputFile, int maximumFailures) {
        BuildOperationLogInfo configuration = this.logger.isDebugEnabled() ? new BuildOperationLogInfo(taskName, outputFile, Integer.MAX_VALUE) : new BuildOperationLogInfo(taskName, outputFile, maximumFailures);
        return configuration;
    }
}

