/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.id.IdGenerator;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.process.internal.DefaultSingleUseWorkerProcessBuilder;
import org.gradle.process.internal.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.SingleUseWorkerProcessBuilder;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.process.internal.WorkerProcessFactory;
import org.gradle.process.internal.child.ApplicationClassesInSystemClassLoaderWorkerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessFactory
implements WorkerProcessFactory {
    private final LogLevel workerLogLevel;
    private final MessagingServer server;
    private final IdGenerator<?> idGenerator;
    private final File gradleUserHomeDir;
    private final ExecHandleFactory execHandleFactory;
    private final ApplicationClassesInSystemClassLoaderWorkerFactory workerFactory;
    private int connectTimeoutSeconds = 120;

    public DefaultWorkerProcessFactory(LogLevel workerLogLevel, MessagingServer server, ClassPathRegistry classPathRegistry, IdGenerator<?> idGenerator, File gradleUserHomeDir, TemporaryFileProvider temporaryFileProvider, ExecHandleFactory execHandleFactory) {
        this.workerLogLevel = workerLogLevel;
        this.server = server;
        this.idGenerator = idGenerator;
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.execHandleFactory = execHandleFactory;
        this.workerFactory = new ApplicationClassesInSystemClassLoaderWorkerFactory(classPathRegistry, temporaryFileProvider);
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public WorkerProcessBuilder create(Action<? super WorkerProcessContext> workerAction) {
        DefaultWorkerProcessBuilder builder = this.newWorker();
        builder.worker(workerAction);
        builder.setImplementationClasspath(ClasspathUtil.getClasspath((ClassLoader)workerAction.getClass().getClassLoader()));
        return builder;
    }

    private DefaultWorkerProcessBuilder newWorker() {
        DefaultWorkerProcessBuilder workerProcessBuilder = new DefaultWorkerProcessBuilder(this.execHandleFactory, this.server, this.idGenerator, this.workerFactory);
        workerProcessBuilder.setLogLevel(this.workerLogLevel);
        workerProcessBuilder.setGradleUserHomeDir(this.gradleUserHomeDir);
        workerProcessBuilder.setConnectTimeoutSeconds(this.connectTimeoutSeconds);
        return workerProcessBuilder;
    }

    @Override
    public <T> SingleUseWorkerProcessBuilder<T> create(Class<T> protocolType, Class<? extends T> workerImplementation) {
        DefaultWorkerProcessBuilder builder = this.newWorker();
        return new DefaultSingleUseWorkerProcessBuilder<T>(protocolType, workerImplementation, builder);
    }
}

