/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.tring;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class Quad {
    private final boolean clockwise;
    private final MoveTo moveTo0 = new MoveTo();
    private final LineTo lineTo1 = new LineTo();
    private final LineTo lineTo2 = new LineTo();
    private final LineTo lineTo3 = new LineTo();

    public Quad(boolean clockwise) {
        this.clockwise = clockwise;
    }

    public Quad() {
        this(true);
    }

    public void addToPath(Path path) {
        assert (path != null);
        ObservableList ringElements = path.getElements();
        if (this.clockwise) {
            ringElements.add(this.moveTo0);
            ringElements.add(this.lineTo1);
            ringElements.add(this.lineTo2);
            ringElements.add(this.lineTo3);
        } else {
            ringElements.add(this.moveTo0);
            ringElements.add(this.lineTo3);
            ringElements.add(this.lineTo2);
            ringElements.add(this.lineTo1);
        }
        ringElements.add(new ClosePath());
    }

    public void removeFromPath(Path path) {
        assert (path != null);
        assert (path.getElements().contains((Object)this.moveTo0));
        ObservableList ringElements = path.getElements();
        ringElements.remove(this.moveTo0);
        ringElements.remove(this.lineTo1);
        ringElements.remove(this.lineTo2);
        ringElements.remove(this.lineTo3);
    }

    public double getX0() {
        return this.moveTo0.getX();
    }

    public void setX0(double x) {
        this.moveTo0.setX(x);
    }

    public double getY0() {
        return this.moveTo0.getY();
    }

    public void setY0(double y) {
        this.moveTo0.setY(y);
    }

    public double getX1() {
        return this.lineTo1.getX();
    }

    public void setX1(double x) {
        this.lineTo1.setX(x);
    }

    public double getY1() {
        return this.lineTo1.getY();
    }

    public void setY1(double y) {
        this.lineTo1.setY(y);
    }

    public double getX2() {
        return this.lineTo2.getX();
    }

    public void setX2(double x) {
        this.lineTo2.setX(x);
    }

    public double getY2() {
        return this.lineTo2.getY();
    }

    public void setY2(double y) {
        this.lineTo2.setY(y);
    }

    public double getX3() {
        return this.lineTo3.getX();
    }

    public void setX3(double x) {
        this.lineTo3.setX(x);
    }

    public double getY3() {
        return this.lineTo3.getY();
    }

    public void setY3(double y) {
        this.lineTo3.setY(y);
    }

    public void setBounds(Bounds bounds) {
        this.moveTo0.setX(bounds.getMinX());
        this.moveTo0.setY(bounds.getMinY());
        this.lineTo1.setX(bounds.getMaxX());
        this.lineTo1.setY(bounds.getMinY());
        this.lineTo2.setX(bounds.getMaxX());
        this.lineTo2.setY(bounds.getMaxY());
        this.lineTo3.setX(bounds.getMinX());
        this.lineTo3.setY(bounds.getMaxY());
    }

    public void insets(Insets insets) {
        this.moveTo0.setX(this.moveTo0.getX() + insets.getLeft());
        this.moveTo0.setY(this.moveTo0.getY() + insets.getTop());
        this.lineTo1.setX(this.lineTo1.getX() - insets.getRight());
        this.lineTo1.setY(this.lineTo1.getY() + insets.getTop());
        this.lineTo2.setX(this.lineTo2.getX() - insets.getRight());
        this.lineTo2.setY(this.lineTo2.getY() - insets.getBottom());
        this.lineTo3.setX(this.lineTo3.getX() + insets.getLeft());
        this.lineTo3.setY(this.lineTo3.getY() - insets.getBottom());
    }

    public void insets(Insets insets, double minInset) {
        assert (minInset >= 0.0);
        this.moveTo0.setX(this.moveTo0.getX() + Math.max(minInset, insets.getLeft()));
        this.moveTo0.setY(this.moveTo0.getY() + Math.max(minInset, insets.getTop()));
        this.lineTo1.setX(this.lineTo1.getX() - Math.max(minInset, insets.getRight()));
        this.lineTo1.setY(this.lineTo1.getY() + Math.max(minInset, insets.getTop()));
        this.lineTo2.setX(this.lineTo2.getX() - Math.max(minInset, insets.getRight()));
        this.lineTo2.setY(this.lineTo2.getY() - Math.max(minInset, insets.getBottom()));
        this.lineTo3.setX(this.lineTo3.getX() + Math.max(minInset, insets.getLeft()));
        this.lineTo3.setY(this.lineTo3.getY() - Math.max(minInset, insets.getBottom()));
    }
}

