/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.key;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.JobManager;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.RelocateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.key.AbstractKeyGesture;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.HashMap;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;

public class MoveWithKeyGesture
extends AbstractKeyGesture {
    private double vectorX;
    private double vectorY;

    public MoveWithKeyGesture(ContentPanelController contentPanelController) {
        super(contentPanelController);
        assert (RelocateSelectionJob.isSelectionMovable(contentPanelController.getEditorController()));
    }

    @Override
    protected void keyPressed() {
        double extend = this.getLastKeyEvent().isShiftDown() ? 10.0 : 1.0;
        double moveX = extend * this.vectorX;
        double moveY = extend * this.vectorY;
        Selection selection = this.contentPanelController.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        for (FXOMObject selectedObject : osg.getFlattenItems()) {
            assert (selectedObject.isNode());
            Node node = (Node)selectedObject.getSceneGraphObject();
            node.setLayoutX(node.getLayoutX() + moveX);
            node.setLayoutY(node.getLayoutY() + moveY);
        }
    }

    @Override
    protected void keyReleased() {
        this.keyPressed();
        EditorController editorController = this.contentPanelController.getEditorController();
        Selection selection = editorController.getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        HashMap<FXOMObject, Point2D> locationMap = new HashMap<FXOMObject, Point2D>();
        for (FXOMObject selectedObject : osg.getItems()) {
            assert (selectedObject.isNode());
            assert (selectedObject instanceof FXOMInstance);
            Node node = (Node)selectedObject.getSceneGraphObject();
            Point2D layoutXY = new Point2D(node.getLayoutX(), node.getLayoutY());
            locationMap.put(selectedObject, layoutXY);
        }
        RelocateSelectionJob newRelocateJob = new RelocateSelectionJob(locationMap, editorController);
        JobManager jobManager = editorController.getJobManager();
        Job currentJob = jobManager.getCurrentJob();
        if (currentJob instanceof RelocateSelectionJob) {
            RelocateSelectionJob currentRelocateJob = (RelocateSelectionJob)currentJob;
            if (currentRelocateJob.canBeMergedWith(newRelocateJob)) {
                newRelocateJob.execute();
                currentRelocateJob.mergeWith(newRelocateJob);
            } else {
                jobManager.push(newRelocateJob);
            }
        } else {
            jobManager.push(newRelocateJob);
        }
    }

    @Override
    public void start(InputEvent e, AbstractGesture.Observer observer) {
        super.start(e, observer);
        switch (this.getFirstKeyPressedEvent().getCode()) {
            case DOWN: {
                this.vectorX = 0.0;
                this.vectorY = 1.0;
                break;
            }
            case UP: {
                this.vectorX = 0.0;
                this.vectorY = -1.0;
                break;
            }
            case LEFT: {
                this.vectorX = -1.0;
                this.vectorY = 0.0;
                break;
            }
            case RIGHT: {
                this.vectorX = 1.0;
                this.vectorY = 0.0;
                break;
            }
            default: {
                assert (false) : "Unexpected key code" + this.getFirstKeyPressedEvent().getCode();
                this.vectorX = 0.0;
                this.vectorY = 0.0;
            }
        }
    }
}

