/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class InsetsEditor
extends PropertyEditor {
    private Parent root;
    @FXML
    private Button linkBt;
    @FXML
    private TextField bottomTf;
    @FXML
    private TextField leftTf;
    @FXML
    private TextField rightTf;
    @FXML
    private TextField topTf;
    TextField[] textFields = new TextField[4];
    TextField errorTf;

    public InsetsEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.root = EditorUtils.loadFxml("InsetsEditor.fxml", (Object)this);
        this.textFields[0] = this.topTf;
        this.textFields[1] = this.rightTf;
        this.textFields[2] = this.bottomTf;
        this.textFields[3] = this.leftTf;
        for (TextField tf : this.textFields) {
            EventHandler valueListener = event -> {
                if (this.isHandlingError()) {
                    return;
                }
                this.userUpdateValueProperty(this.getValue());
            };
            this.setNumericEditorBehavior(this, (Control)tf, (EventHandler<ActionEvent>)valueListener, false);
        }
        this.linkBt.disableProperty().bind((ObservableValue)this.disableProperty());
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        Double[] values = new Double[4];
        int index = 0;
        for (TextField tf : this.textFields) {
            String val = tf.getText();
            if (val == null || val.isEmpty()) {
                val = "0";
            }
            try {
                Double.parseDouble(val);
            }
            catch (NumberFormatException e) {
                this.errorTf = tf;
                this.handleInvalidValue(val);
                return null;
            }
            values[index] = Double.valueOf(val);
            ++index;
        }
        return new Insets(values[0].doubleValue(), values[1].doubleValue(), values[2].doubleValue(), values[3].doubleValue());
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            value = Insets.EMPTY;
        }
        Insets insets = (Insets)value;
        this.topTf.setText(EditorUtils.valAsStr(insets.getTop()));
        this.rightTf.setText(EditorUtils.valAsStr(insets.getRight()));
        this.bottomTf.setText(EditorUtils.valAsStr(insets.getBottom()));
        this.leftTf.setText(EditorUtils.valAsStr(insets.getLeft()));
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM);
    }

    @Override
    protected void valueIsIndeterminate() {
        for (TextField tf : this.textFields) {
            InsetsEditor.handleIndeterminate((Node)tf);
        }
    }

    @FXML
    void linkValuesAction(ActionEvent event) {
        this.linkValues();
    }

    @FXML
    void linkValuesKeypressed(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.linkValues();
        }
    }

    private void linkValues() {
        String t = this.topTf.getText();
        this.rightTf.setText(t);
        this.bottomTf.setText(t);
        this.leftTf.setText(t);
        this.userUpdateValueProperty(this.getValue());
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> {
            if (this.errorTf != null) {
                this.errorTf.requestFocus();
            } else {
                this.topTf.requestFocus();
            }
        });
    }
}

