/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ResourceKeyCollector
extends ResourceBundle {
    private final ResourceBundle backingResources;

    public ResourceKeyCollector(ResourceBundle backingResources) {
        this.backingResources = backingResources;
    }

    @Override
    protected Object handleGetObject(String key) {
        Object result;
        if (this.backingResources != null) {
            try {
                result = this.backingResources.getObject(key);
            }
            catch (MissingResourceException x) {
                result = null;
            }
        } else {
            result = null;
        }
        if (result == null) {
            result = "%" + key;
        }
        return result;
    }

    @Override
    public Enumeration<String> getKeys() {
        return new EnumerationFromIterator<String>(Collections.emptyListIterator());
    }

    @Override
    public boolean containsKey(String key) {
        return true;
    }

    private static class EnumerationFromIterator<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        public EnumerationFromIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

