/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class EnumControl<T>
extends GridPane {
    @FXML
    private Label editor_label;
    @FXML
    private ChoiceBox<T> editor_choicebox;
    private final ObjectProperty<T> value = new SimpleObjectProperty();
    private final EffectPickerController effectPickerController;

    public EnumControl(EffectPickerController effectPickerController, String label, T[] values, T initValue) {
        this.effectPickerController = effectPickerController;
        this.initialize(label, values, initValue);
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public T getValue() {
        return (T)this.value.get();
    }

    public void setValue(T v) {
        this.value.set(v);
    }

    private void initialize(String label, T[] values, T initValue) {
        URL layoutURL = EnumControl.class.getResource("EnumControl.fxml");
        try (InputStream is = layoutURL.openStream();){
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setLocation(layoutURL);
            Parent p = (Parent)loader.load(is);
            assert (p == this);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.editor_label.setText(label);
        this.editor_choicebox.getItems().addAll((Object[])values);
        this.editor_choicebox.setValue(initValue);
        this.editor_choicebox.getSelectionModel().selectedItemProperty().addListener((ov, t, t1) -> {
            this.setValue(t1);
            this.effectPickerController.incrementRevision();
        });
        this.setValue(initValue);
        this.editor_choicebox.addEventHandler(ActionEvent.ACTION, event -> event.consume());
    }
}

