/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.colorpicker.ColorPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPicker;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class GradientPickerStop
extends VBox {
    @FXML
    private Rectangle chip_rect;
    @FXML
    private ImageView indicator_image;
    @FXML
    private TextField offset_textfield;
    @FXML
    private ContextMenu context_menu;
    @FXML
    private CustomMenuItem custom_menu_item;
    @FXML
    private Button stop_button;
    private final double min;
    private final double max;
    private double offset;
    private Color color;
    private boolean isSelected;
    private double origX;
    private double startDragX;
    private double thumbWidth;
    private final double edgeMargin = 2.0;
    private final GradientPicker gradientPicker;

    private static double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public GradientPickerStop(GradientPicker ge, double mini, double maxi, double val, Color c) {
        this.gradientPicker = ge;
        this.min = mini;
        this.max = maxi;
        this.offset = val;
        this.color = c;
        this.initialize();
    }

    public void setOffset(double val) {
        this.offset = GradientPickerStop.clamp(this.min, val, this.max);
        this.valueToPixels();
    }

    public double getOffset() {
        return this.offset;
    }

    public void setColor(Color c) {
        this.color = c;
        this.chip_rect.setFill((Paint)c);
    }

    public Color getColor() {
        return this.color;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
        if (selected) {
            this.indicator_image.setVisible(true);
        } else {
            this.indicator_image.setVisible(false);
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    private void initialize() {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(GradientPickerStop.class.getResource("GradientPickerStop.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(GradientPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (this.offset_textfield != null);
        assert (this.chip_rect != null);
        this.offset_textfield.setText("" + this.offset);
        this.chip_rect.setFill((Paint)this.color);
        this.gradientPicker.setSelectedStop(this);
        this.stop_button.setOnAction(event -> event.consume());
        this.widthProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue.doubleValue() > 0.0) {
                this.thumbWidth = newValue.doubleValue();
                this.valueToPixels();
            }
        });
    }

    @FXML
    void stopAction(ActionEvent event) {
        double val = Double.valueOf(this.offset_textfield.getText());
        this.setOffset(val);
        this.showHUD();
        PaintPickerController paintPicker = this.gradientPicker.getPaintPickerController();
        PaintPicker.Mode mode = paintPicker.getMode();
        Paint value = this.gradientPicker.getValue(mode);
        this.gradientPicker.updatePreview(value);
        paintPicker.setPaintProperty(value);
    }

    @FXML
    void thumbKeyPressed(KeyEvent e) {
        if (e.getCode() == KeyCode.BACK_SPACE || e.getCode() == KeyCode.DELETE) {
            this.gradientPicker.removeStop(this);
            PaintPickerController paintPicker = this.gradientPicker.getPaintPickerController();
            PaintPicker.Mode mode = paintPicker.getMode();
            Paint value = this.gradientPicker.getValue(mode);
            this.gradientPicker.updatePreview(value);
            paintPicker.setPaintProperty(value);
            e.consume();
        }
    }

    @FXML
    void thumbMousePressed(MouseEvent event) {
        this.gradientPicker.setSelectedStop(this);
        this.startDragX = event.getSceneX();
        this.origX = this.getLayoutX();
        this.toFront();
        this.pixelsToValue();
        PaintPickerController paintPicker = this.gradientPicker.getPaintPickerController();
        ColorPicker colorPicker = paintPicker.getColorPicker();
        colorPicker.updateUI(this.color);
        this.stop_button.requestFocus();
    }

    @FXML
    void thumbMouseReleased() {
        this.pixelsToValue();
    }

    @FXML
    void thumbMouseDragged(MouseEvent event) {
        double dragValue = event.getSceneX() - this.startDragX;
        double deltaX = this.origX + dragValue;
        double trackWidth = this.getParent().getBoundsInLocal().getWidth();
        Double newX = GradientPickerStop.clamp(2.0, deltaX, trackWidth - (this.getWidth() + 2.0));
        this.setLayoutX(newX);
        this.pixelsToValue();
        PaintPickerController paintPicker = this.gradientPicker.getPaintPickerController();
        PaintPicker.Mode mode = paintPicker.getMode();
        Paint value = this.gradientPicker.getValue(mode);
        this.gradientPicker.updatePreview(value);
        paintPicker.setPaintProperty(value);
    }

    private void showHUD() {
        this.offset_textfield.setText(Double.toString(this.offset));
        this.context_menu.show((Node)this, Side.BOTTOM, 0.0, 5.0);
    }

    private void valueToPixels() {
        double stopValue = GradientPickerStop.clamp(this.min, this.offset, this.max);
        double availablePixels = this.getParent().getLayoutBounds().getWidth() - (this.thumbWidth + 2.0);
        double range = this.max - this.min;
        double pixelPosition = availablePixels / range * stopValue;
        this.setLayoutX(pixelPosition);
    }

    private void pixelsToValue() {
        double range = this.max - this.min;
        double availablePixels = this.getParent().getLayoutBounds().getWidth() - (this.thumbWidth + 2.0);
        this.setOffset(this.min + this.getLayoutX() * (range / availablePixels));
    }
}

