/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.bridge.svg12.SVG12BridgeUpdateHandler;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg12.XBLEventSupport;
import org.apache.batik.dom.xbl.NodeXBL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.MutationEvent;

public class SVG12TextElementBridge
extends SVGTextElementBridge
implements SVG12BridgeUpdateHandler {
    @Override
    public Bridge getInstance() {
        return new SVG12TextElementBridge();
    }

    @Override
    protected void addTextEventListeners(BridgeContext bridgeContext, NodeEventTarget nodeEventTarget) {
        if (this.childNodeRemovedEventListener == null) {
            this.childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
        }
        if (this.subtreeModifiedEventListener == null) {
            this.subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
        }
        SVG12BridgeContext sVG12BridgeContext = (SVG12BridgeContext)bridgeContext;
        AbstractNode abstractNode = (AbstractNode)nodeEventTarget;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        sVG12BridgeContext.storeImplementationEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        sVG12BridgeContext.storeImplementationEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
    }

    @Override
    protected void removeTextEventListeners(BridgeContext bridgeContext, NodeEventTarget nodeEventTarget) {
        AbstractNode abstractNode = (AbstractNode)nodeEventTarget;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractNode.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
    }

    @Override
    protected Node getFirstChild(Node node) {
        return ((NodeXBL)((Object)node)).getXblFirstChild();
    }

    @Override
    protected Node getNextSibling(Node node) {
        return ((NodeXBL)((Object)node)).getXblNextSibling();
    }

    @Override
    protected Node getParentNode(Node node) {
        return ((NodeXBL)((Object)node)).getXblParentNode();
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        if (this.isParentDisplayed(node)) {
            if (this.getParentNode(node) != node.getParentNode()) {
                this.computeLaidoutText(this.ctx, this.e, this.node);
            } else {
                this.laidoutText = null;
            }
        }
    }

    @Override
    public void handleBindingEvent(Element element, Element element2) {
    }

    @Override
    public void handleContentSelectionChangedEvent(ContentSelectionChangedEvent contentSelectionChangedEvent) {
        this.computeLaidoutText(this.ctx, this.e, this.node);
    }

    protected class DOMSubtreeModifiedEventListener
    extends SVGTextElementBridge.DOMSubtreeModifiedEventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }

    protected class DOMChildNodeRemovedEventListener
    extends SVGTextElementBridge.DOMChildNodeRemovedEventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            super.handleEvent(EventSupport.getUltimateOriginalEvent(event));
        }
    }
}

