/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.artifacts;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactPropertiesEditor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.model.impl.artifacts.AntArtifactExtensionProperties;

public class AntArtifactProperties
extends ArtifactProperties<AntArtifactExtensionProperties> {
    private AntArtifactExtensionProperties myExtensionProperties = new AntArtifactExtensionProperties();
    private boolean myPostProcessing;

    public AntArtifactProperties(boolean postProcessing) {
        this.myPostProcessing = postProcessing;
    }

    public ArtifactPropertiesEditor createEditor(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties", "createEditor"));
        }
        return new AntArtifactPropertiesEditor(this, context, this.myPostProcessing);
    }

    public AntArtifactExtensionProperties getState() {
        return this.myExtensionProperties;
    }

    public void onBuildStarted(@NotNull Artifact artifact, @NotNull CompileContext compileContext) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties", "onBuildStarted"));
        }
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties", "onBuildStarted"));
        }
        if (!this.myPostProcessing) {
            this.runAntTarget(compileContext, artifact);
        }
    }

    public void onBuildFinished(@NotNull Artifact artifact, @NotNull CompileContext compileContext) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties", "onBuildFinished"));
        }
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties", "onBuildFinished"));
        }
        if (this.myPostProcessing) {
            this.runAntTarget(compileContext, artifact);
        }
    }

    private void runAntTarget(CompileContext compileContext, Artifact artifact) {
        List<BuildFileProperty> properties;
        DataContext dataContext;
        boolean success;
        Project project;
        AntBuildTarget target;
        if (this.myExtensionProperties.myEnabled && (target = this.findTarget(AntConfiguration.getInstance(project = compileContext.getProject()))) != null && !(success = AntConfigurationImpl.executeTargetSynchronously(dataContext = SimpleDataContext.getProjectContext((Project)project), target, properties = this.getAllProperties(artifact)))) {
            compileContext.addMessage(CompilerMessageCategory.ERROR, "Cannot build artifact '" + artifact.getName() + "': ant target '" + target.getDisplayName() + "' failed with error", null, -1, -1);
        }
    }

    public void loadState(AntArtifactExtensionProperties state) {
        this.myExtensionProperties = state;
    }

    public String getFileUrl() {
        return this.myExtensionProperties.myFileUrl;
    }

    public String getTargetName() {
        return this.myExtensionProperties.myTargetName;
    }

    public boolean isEnabled() {
        return this.myExtensionProperties.myEnabled;
    }

    public List<BuildFileProperty> getUserProperties() {
        return this.myExtensionProperties.myUserProperties;
    }

    public void setUserProperties(List<BuildFileProperty> userProperties) {
        this.myExtensionProperties.myUserProperties = userProperties;
    }

    public void setEnabled(boolean enabled) {
        this.myExtensionProperties.myEnabled = enabled;
    }

    public void setFileUrl(String fileUrl) {
        this.myExtensionProperties.myFileUrl = fileUrl;
    }

    public void setTargetName(String targetName) {
        this.myExtensionProperties.myTargetName = targetName;
    }

    @Nullable
    public AntBuildTarget findTarget(AntConfiguration antConfiguration) {
        AntBuildFile[] buildFiles;
        String fileUrl = this.getFileUrl();
        String targetName = this.getTargetName();
        if (fileUrl == null || targetName == null) {
            return null;
        }
        for (AntBuildFile buildFile : buildFiles = antConfiguration.getBuildFiles()) {
            VirtualFile file = buildFile.getVirtualFile();
            if (file == null || !file.getUrl().equals(fileUrl)) continue;
            AntBuildModel buildModel = buildFile.getModel();
            return buildModel != null ? buildModel.findTarget(targetName) : null;
        }
        return null;
    }

    public List<BuildFileProperty> getAllProperties(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/lang/ant/config/impl/artifacts/AntArtifactProperties", "getAllProperties"));
        }
        ArrayList<BuildFileProperty> properties = new ArrayList<BuildFileProperty>();
        properties.add(new BuildFileProperty("artifact.output.path", artifact.getOutputPath()));
        properties.addAll(this.myExtensionProperties.myUserProperties);
        return properties;
    }

    public static boolean isPredefinedProperty(String propertyName) {
        return "artifact.output.path".equals(propertyName);
    }
}

