/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.pom.Navigatable;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.ExecutionNode;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;

public class TaskExecutionTreeTable
extends TreeTable {
    private static final ExecutionNode NULL_NODE = new ExecutionNode(null, "");

    public TaskExecutionTreeTable(ListTreeTableModelOnColumns model) {
        super((TreeTableModel)model);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && TaskExecutionTreeTable.this.hasSingleSelection()) {
                    TaskExecutionTreeTable.this.handleDoubleClickOrEnter(TaskExecutionTreeTable.this.getTree().getSelectionPath(), e);
                }
                if (e.getKeyCode() == 113 && e.getModifiers() == 0) {
                    e.consume();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger() && SimpleTree.isDoubleClick((MouseEvent)e)) {
                    TaskExecutionTreeTable.this.handleDoubleClickOrEnter(TaskExecutionTreeTable.this.getTree().getClosestPathForLocation(e.getX(), e.getY()), e);
                }
            }
        });
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup;
                String id = this.getMenuId(TaskExecutionTreeTable.this.getSelectedNodes());
                if (id != null && (actionGroup = (ActionGroup)actionManager.getAction(id)) != null) {
                    actionManager.createActionPopupMenu("", actionGroup).getComponent().show(comp, x, y);
                }
            }

            @Nullable
            private String getMenuId(Collection<? extends ExecutionNode> nodes) {
                String id = null;
                for (ExecutionNode executionNode : nodes) {
                    String menuId = executionNode.getMenuId();
                    if (menuId == null) {
                        return null;
                    }
                    if (id == null) {
                        id = menuId;
                        continue;
                    }
                    if (id.equals(menuId)) continue;
                    return null;
                }
                return id;
            }
        });
    }

    private Collection<? extends ExecutionNode> getSelectedNodes() {
        Object[] selectionPaths = this.getTree().getSelectionPaths();
        if (selectionPaths != null) {
            return ContainerUtil.map((Object[])selectionPaths, path -> this.getNodeFor((TreePath)path));
        }
        return Collections.emptyList();
    }

    public boolean isSelectionEmpty() {
        TreePath selection = this.getTree().getSelectionPath();
        return selection == null || this.getNodeFor(selection) == NULL_NODE;
    }

    public ExecutionNode getNodeFor(TreePath aPath) {
        if (aPath == null) {
            return NULL_NODE;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)aPath.getLastPathComponent();
        if (treeNode == null) {
            return NULL_NODE;
        }
        Object userObject = treeNode.getUserObject();
        return userObject instanceof ExecutionNode ? (ExecutionNode)((Object)userObject) : NULL_NODE;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            final TableCellRenderer cellRenderer = super.getCellRenderer(row, column);
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Color bg = isSelected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                    component.setBackground(bg);
                    return component;
                }
            };
        }
        if (column == 1) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setHorizontalAlignment(4);
                    Color fg = isSelected ? UIUtil.getTreeSelectionForeground() : SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor();
                    this.setForeground(fg);
                    return this;
                }
            };
        }
        return super.getCellRenderer(row, column);
    }

    private void handleDoubleClickOrEnter(TreePath treePath, InputEvent e) {
        Runnable runnable = () -> {
            ExecutionNode executionNode = this.getNodeFor(treePath);
            if (executionNode != NULL_NODE) {
                TaskExecutionTreeTable.handleDoubleClickOrEnter(executionNode, e);
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)((Object)this)));
    }

    private static void handleDoubleClickOrEnter(ExecutionNode executionNode, InputEvent e) {
        Object openFileDescriptor;
        OperationDescriptor descriptor = executionNode.getInfo().getDescriptor();
        if (descriptor instanceof TestOperationDescriptor && executionNode.getProject() != null && (openFileDescriptor = GradleRunnerUtil.getData(executionNode.getProject(), CommonDataKeys.NAVIGATABLE.getName(), executionNode.getInfo())) instanceof Navigatable) {
            boolean isKeyEnterEvent;
            boolean bl = isKeyEnterEvent = e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 10;
            if (isKeyEnterEvent || executionNode.getChildren().length == 0) {
                ((Navigatable)openFileDescriptor).navigate(!isKeyEnterEvent);
            }
        }
    }

    private boolean hasSingleSelection() {
        if (!this.isSelectionEmpty()) {
            TreePath[] selectionPaths = this.getTree().getSelectionPaths();
            return selectionPaths != null && selectionPaths.length == 1;
        }
        return false;
    }
}

