/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildScriptClasspathData
extends AbstractExternalEntityData {
    private static final long serialVersionUID = 1L;
    @NotNull
    public static final Key<BuildScriptClasspathData> KEY = Key.create(BuildScriptClasspathData.class, (int)(ProjectKeys.LIBRARY_DEPENDENCY.getProcessingWeight() + 1));
    @Nullable
    private File gradleHomeDir;
    @NotNull
    private final List<ClasspathEntry> myClasspathEntries;

    public BuildScriptClasspathData(@NotNull ProjectSystemId owner, @NotNull List<ClasspathEntry> classpathEntries) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData", "<init>"));
        }
        if (classpathEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classpathEntries", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData", "<init>"));
        }
        super(owner);
        this.myClasspathEntries = classpathEntries;
    }

    @Nullable
    public File getGradleHomeDir() {
        return this.gradleHomeDir;
    }

    public void setGradleHomeDir(@Nullable File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    @NotNull
    public List<ClasspathEntry> getClasspathEntries() {
        List<ClasspathEntry> list = this.myClasspathEntries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData", "getClasspathEntries"));
        }
        return list;
    }

    public static class ClasspathEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @NotNull
        private final Set<String> myClassesFile;
        @NotNull
        private final Set<String> mySourcesFile;
        @NotNull
        private final Set<String> myJavadocFile;

        public ClasspathEntry(@NotNull Set<String> classesFile, @NotNull Set<String> sourcesFile, @NotNull Set<String> javadocFile) {
            if (classesFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesFile", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry", "<init>"));
            }
            if (sourcesFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcesFile", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry", "<init>"));
            }
            if (javadocFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javadocFile", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry", "<init>"));
            }
            this.myClassesFile = classesFile;
            this.mySourcesFile = sourcesFile;
            this.myJavadocFile = javadocFile;
        }

        @NotNull
        public Set<String> getClassesFile() {
            Set<String> set = this.myClassesFile;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry", "getClassesFile"));
            }
            return set;
        }

        @NotNull
        public Set<String> getSourcesFile() {
            Set<String> set = this.mySourcesFile;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry", "getSourcesFile"));
            }
            return set;
        }

        @NotNull
        public Set<String> getJavadocFile() {
            Set<String> set = this.myJavadocFile;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData$ClasspathEntry", "getJavadocFile"));
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClasspathEntry)) {
                return false;
            }
            ClasspathEntry entry = (ClasspathEntry)o;
            if (!this.myClassesFile.equals(entry.myClassesFile)) {
                return false;
            }
            if (!this.myJavadocFile.equals(entry.myJavadocFile)) {
                return false;
            }
            return this.mySourcesFile.equals(entry.mySourcesFile);
        }

        public int hashCode() {
            int result = this.myClassesFile.hashCode();
            result = 31 * result + this.mySourcesFile.hashCode();
            result = 31 * result + this.myJavadocFile.hashCode();
            return result;
        }
    }
}

