/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;

@Order(value=-2147483645)
public class ExternalProjectDataService
extends AbstractProjectDataService<ExternalProject, Project> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectDataService.class);
    @NotNull
    public static final Key<ExternalProject> KEY = Key.create(ExternalProject.class, (int)(ProjectKeys.TASK.getProcessingWeight() + 1));

    @NotNull
    public Key<ExternalProject> getTargetDataKey() {
        Key<ExternalProject> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ExternalProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single external project but got %d: %s", toImport.size(), toImport));
        }
        ExternalProjectDataCache.getInstance(project).saveExternalProject((ExternalProject)toImport.iterator().next().getData());
    }
}

