/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupportedImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.task.AbstractExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.UnsupportedCancellationToken;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTaskManager
extends AbstractExternalSystemTaskManager<GradleExecutionSettings>
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = ContainerUtil.newConcurrentMap();

    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @NotNull List<String> vmOptions, @NotNull List<String> scriptParameters, @Nullable String debuggerSetup, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (vmOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmOptions", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, taskNames, projectPath, settings, vmOptions, scriptParameters, debuggerSetup, listener)) continue;
                return;
            }
        }
        Function f = connection -> {
            GradleVersion gradleVersion;
            GradleProjectResolverExtension projectResolverChain;
            if (taskNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNames", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (scriptParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            if (vmOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmOptions", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "lambda$executeTasks$1"));
            }
            ArrayList initScripts = ContainerUtil.newArrayList();
            for (GradleProjectResolverExtension resolverExtension = projectResolverChain = GradleProjectResolver.createProjectResolverChain(settings); resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
                String resolverClassName = resolverExtension.getClass().getName();
                resolverExtension.enhanceTaskProcessing(taskNames, debuggerSetup, (Consumer<String>)((Consumer)script -> {
                    if (StringUtil.isNotEmpty((String)script)) {
                        ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                    }
                }));
            }
            if (!initScripts.isEmpty()) {
                try {
                    File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((Collection)initScripts, (String)SystemProperties.getLineSeparator()));
                    ContainerUtil.addAll((Collection)scriptParameters, (Object[])new String[]{"--init-script", tempFile.getAbsolutePath()});
                }
                catch (IOException e) {
                    throw new ExternalSystemException((Throwable)e);
                }
            }
            if ((gradleVersion = GradleExecutionHelper.getGradleVersion(connection)) != null && gradleVersion.compareTo(GradleVersion.version((String)"2.5")) < 0) {
                listener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemProgressEventUnsupportedImpl(gradleVersion + " does not support executions view")));
            }
            BuildLauncher launcher = this.myHelper.getBuildLauncher(id, (ProjectConnection)connection, settings, listener, vmOptions, scriptParameters);
            launcher.forTasks(ArrayUtil.toStringArray((Collection)taskNames));
            if (gradleVersion != null && gradleVersion.compareTo(GradleVersion.version((String)"2.1")) < 0) {
                this.myCancellationMap.put(id, new UnsupportedCancellationToken());
            } else {
                CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
                launcher.withCancellationToken(cancellationTokenSource.token());
                this.myCancellationMap.put(id, cancellationTokenSource);
            }
            try {
                launcher.run();
            }
            finally {
                this.myCancellationMap.remove(id);
            }
            return null;
        };
        this.myHelper.execute(projectPath, settings, f);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "cancelTask"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "cancelTask"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener)) continue;
                return true;
            }
        }
        if ((cancellationTokenSource = this.myCancellationMap.get(id)) != null) {
            cancellationTokenSource.cancel();
        }
        return true;
    }
}

