/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.client.methods;

import hidden.org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import hidden.org.apache.jackrabbit.webdav.header.DepthHeader;
import hidden.org.apache.jackrabbit.webdav.header.OverwriteHeader;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;

public class CopyMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(CopyMethod.class);

    public CopyMethod(String uri, String destinationUri, boolean overwrite) {
        this(uri, destinationUri, overwrite, false);
    }

    public CopyMethod(String uri, String destinationUri, boolean overwrite, boolean shallow) {
        super(uri);
        this.setRequestHeader("Destination", destinationUri);
        this.setRequestHeader(new OverwriteHeader(overwrite));
        if (shallow) {
            this.setRequestHeader(new DepthHeader(false));
        }
    }

    public String getName() {
        return "COPY";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 201 || statusCode == 204;
    }
}

