/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.CatchTemplate;
import lombok.ast.DescribedNode;
import lombok.ast.Node;
import lombok.ast.Try;
import lombok.ast.VariableDefinition;

public class Catch
extends AbstractNode
implements DescribedNode {
    private AbstractNode exceptionDeclaration = null;
    private AbstractNode body = null;

    public Try upToTry() {
        if (!(this.getParent() instanceof Try)) {
            return null;
        }
        Try out = (Try)this.getParent();
        if (!out.rawCatches().contains(this)) {
            return null;
        }
        return out;
    }

    public VariableDefinition astExceptionDeclaration() {
        if (!(this.exceptionDeclaration instanceof VariableDefinition)) {
            return null;
        }
        return (VariableDefinition)this.exceptionDeclaration;
    }

    public Catch astExceptionDeclaration(VariableDefinition exceptionDeclaration) {
        if (exceptionDeclaration == null) {
            throw new NullPointerException("exceptionDeclaration is mandatory");
        }
        return this.rawExceptionDeclaration(exceptionDeclaration);
    }

    public Node rawExceptionDeclaration() {
        return this.exceptionDeclaration;
    }

    public Catch rawExceptionDeclaration(Node exceptionDeclaration) {
        if (exceptionDeclaration == this.exceptionDeclaration) {
            return this;
        }
        if (exceptionDeclaration != null) {
            this.adopt((AbstractNode)exceptionDeclaration);
        }
        if (this.exceptionDeclaration != null) {
            this.disown(this.exceptionDeclaration);
        }
        this.exceptionDeclaration = (AbstractNode)exceptionDeclaration;
        return this;
    }

    public Block astBody() {
        if (!(this.body instanceof Block)) {
            return null;
        }
        return (Block)this.body;
    }

    public Catch astBody(Block body) {
        if (body == null) {
            throw new NullPointerException("body is mandatory");
        }
        return this.rawBody(body);
    }

    public Node rawBody() {
        return this.body;
    }

    public Catch rawBody(Node body) {
        if (body == this.body) {
            return this;
        }
        if (body != null) {
            this.adopt((AbstractNode)body);
        }
        if (this.body != null) {
            this.disown(this.body);
        }
        this.body = (AbstractNode)body;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.exceptionDeclaration != null) {
            result.add(this.exceptionDeclaration);
        }
        if (this.body != null) {
            result.add(this.body);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.exceptionDeclaration == original) {
            this.rawExceptionDeclaration(replacement);
            return true;
        }
        if (this.body == original) {
            this.rawBody(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.exceptionDeclaration == child) {
            this.disown((AbstractNode)child);
            this.exceptionDeclaration = null;
            return true;
        }
        if (this.body == child) {
            this.disown((AbstractNode)child);
            this.body = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitCatch(this)) {
            return;
        }
        if (this.exceptionDeclaration != null) {
            this.exceptionDeclaration.accept(visitor);
        }
        if (this.body != null) {
            this.body.accept(visitor);
        }
        visitor.afterVisitCatch(this);
        visitor.endVisit(this);
    }

    @Override
    public Catch copy() {
        Catch result = new Catch();
        if (this.exceptionDeclaration != null) {
            result.rawExceptionDeclaration(this.exceptionDeclaration.copy());
        }
        if (this.body != null) {
            result.rawBody(this.body.copy());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return CatchTemplate.getDescription(this);
    }
}

