/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import lombok.ast.AbstractNode;
import lombok.ast.Node;

public class DanglingNodes {
    private static WeakHashMap<Node, List<Node>> store = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDanglingNode(Node on, Node danglingNode) {
        if (on instanceof AbstractNode) {
            ((AbstractNode)on).addDanglingNode(danglingNode);
        } else {
            WeakHashMap<Node, List<Node>> weakHashMap = store;
            synchronized (weakHashMap) {
                List<Node> list = store.get(on);
                if (list == null) {
                    list = new ArrayList<Node>();
                    store.put(on, list);
                }
                list.add(danglingNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Node> getDanglingNodes(Node on) {
        if (on instanceof AbstractNode) {
            return ((AbstractNode)on).getDanglingNodes();
        }
        WeakHashMap<Node, List<Node>> weakHashMap = store;
        synchronized (weakHashMap) {
            List<Node> list = store.get(on);
            if (list == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(list);
        }
    }

    public static void removeDanglingNode(Node on, Node danglingNode) {
        if (on instanceof AbstractNode) {
            ((AbstractNode)on).removeDanglingNode(danglingNode);
        } else {
            List<Node> list = store.get(on);
            if (list != null) {
                list.remove(danglingNode);
            }
        }
    }
}

