/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;

public class SvnMapping {
    private final List<VirtualFile> myLonelyRoots;
    private final TreeMap<String, RootUrlInfo> myFile2UrlMap = new TreeMap(FilePathsComparator.getInstance());
    private final Map<String, RootUrlInfo> myUrl2FileMap = new HashMap<String, RootUrlInfo>();
    private boolean myRootsDifferFromSettings = false;
    private List<VirtualFile> myPreCalculatedUnderVcsRoots = null;

    public SvnMapping() {
        this.myLonelyRoots = new ArrayList<VirtualFile>();
    }

    public void copyFrom(SvnMapping other) {
        this.myFile2UrlMap.clear();
        this.myUrl2FileMap.clear();
        this.myLonelyRoots.clear();
        this.myFile2UrlMap.putAll(other.myFile2UrlMap);
        this.myUrl2FileMap.putAll(other.myUrl2FileMap);
        this.myLonelyRoots.addAll(other.myLonelyRoots);
        this.myRootsDifferFromSettings = other.myRootsDifferFromSettings;
        this.myPreCalculatedUnderVcsRoots = null;
    }

    public void addAll(Collection<RootUrlInfo> roots) {
        for (RootUrlInfo rootInfo : roots) {
            VirtualFile file = rootInfo.getVirtualFile();
            File ioFile = new File(file.getPath());
            this.myRootsDifferFromSettings |= !rootInfo.getRoot().getPath().equals(file.getPath());
            this.myFile2UrlMap.put(ioFile.getAbsolutePath(), rootInfo);
            this.myUrl2FileMap.put(rootInfo.getAbsoluteUrl(), rootInfo);
        }
    }

    public void add(RootUrlInfo rootInfo) {
        VirtualFile file = rootInfo.getVirtualFile();
        File ioFile = new File(file.getPath());
        this.myRootsDifferFromSettings |= !rootInfo.getRoot().getPath().equals(file.getPath());
        this.myFile2UrlMap.put(ioFile.getAbsolutePath(), rootInfo);
        this.myUrl2FileMap.put(rootInfo.getAbsoluteUrl(), rootInfo);
    }

    public List<VirtualFile> getUnderVcsRoots() {
        if (this.myPreCalculatedUnderVcsRoots == null) {
            this.myPreCalculatedUnderVcsRoots = new ArrayList<VirtualFile>();
            for (RootUrlInfo info : this.myFile2UrlMap.values()) {
                this.myPreCalculatedUnderVcsRoots.add(info.getVirtualFile());
            }
        }
        return this.myPreCalculatedUnderVcsRoots;
    }

    public List<RootUrlInfo> getAllCopies() {
        return new ArrayList<RootUrlInfo>(this.myFile2UrlMap.values());
    }

    @Nullable
    public String getRootForPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnMapping", "getRootForPath"));
        }
        String floor = this.myFile2UrlMap.floorKey(path);
        if (floor == null) {
            return null;
        }
        NavigableMap<String, RootUrlInfo> head = this.myFile2UrlMap.headMap(floor, true);
        for (String root : head.descendingKeySet()) {
            if (!this.startsWithForPaths(root, path)) continue;
            return root;
        }
        return null;
    }

    public Collection<String> getUrls() {
        return this.myUrl2FileMap.keySet();
    }

    public RootUrlInfo byFile(String path) {
        return this.myFile2UrlMap.get(path);
    }

    public RootUrlInfo byUrl(String url) {
        return this.myUrl2FileMap.get(url);
    }

    public boolean isEmpty() {
        return this.myUrl2FileMap.isEmpty();
    }

    public boolean isRootsDifferFromSettings() {
        return this.myRootsDifferFromSettings;
    }

    public void reportLonelyRoots(Collection<VirtualFile> roots) {
        this.myLonelyRoots.addAll(roots);
    }

    public List<VirtualFile> getLonelyRoots() {
        return this.myLonelyRoots;
    }

    private boolean startsWithForPaths(String parent, String child) {
        return SystemInfo.isFileSystemCaseSensitive ? child.startsWith(parent) : StringUtil.startsWithIgnoreCase((String)child, (String)parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnMapping mapping = (SvnMapping)o;
        if (this.myRootsDifferFromSettings != mapping.myRootsDifferFromSettings) {
            return false;
        }
        if (!this.myFile2UrlMap.equals(mapping.myFile2UrlMap)) {
            return false;
        }
        if (!this.myLonelyRoots.equals(mapping.myLonelyRoots)) {
            return false;
        }
        return this.myUrl2FileMap.equals(mapping.myUrl2FileMap);
    }

    public int hashCode() {
        int result = this.myLonelyRoots.hashCode();
        result = 31 * result + this.myFile2UrlMap.hashCode();
        result = 31 * result + this.myUrl2FileMap.hashCode();
        result = 31 * result + (this.myRootsDifferFromSettings ? 1 : 0);
        return result;
    }

    private static class FilePathsComparator
    implements Comparator<String> {
        private static final FilePathsComparator ourInstance = new FilePathsComparator();

        private FilePathsComparator() {
        }

        public static FilePathsComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(String o1, String o2) {
            return FileUtil.comparePaths((String)o1, (String)o2);
        }
    }
}

