/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.BaseRepositoryProvider;
import org.jetbrains.idea.svn.api.Repository;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class UrlMappingRepositoryProvider
extends BaseRepositoryProvider {
    public UrlMappingRepositoryProvider(@NotNull SvnVcs vcs, @NotNull SvnTarget target) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/UrlMappingRepositoryProvider", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/UrlMappingRepositoryProvider", "<init>"));
        }
        super(vcs, target);
    }

    @Override
    @Nullable
    public Repository get() {
        RootUrlInfo rootInfo = null;
        if (!this.myVcs.getProject().isDefault()) {
            rootInfo = this.myTarget.isFile() ? this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(this.myTarget.getFile()) : this.myVcs.getSvnFileUrlMapping().getWcRootForUrl(this.myTarget.getURL().toDecodedString());
        }
        return rootInfo != null ? new Repository(rootInfo.getRepositoryUrlUrl()) : null;
    }
}

