/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.BaseTerminalModule;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;

public class TerminalUserNamePasswordModule
extends BaseTerminalModule {
    private static final Pattern USER_NAME_PROMPT = Pattern.compile("Username:\\s?");
    private static final Pattern PASSWORD_PROMPT = Pattern.compile("Password for \\'(.*)\\':\\s?");
    private static final Pattern AUTHENTICATION_REALM_MESSAGE = Pattern.compile("Authentication realm: (.*)\\s?");
    private String realm;
    private String userName;
    private SVNPasswordAuthentication authentication;

    public TerminalUserNamePasswordModule(@NotNull CommandRuntime runtime, @NotNull CommandExecutor executor) {
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "org/jetbrains/idea/svn/commandLine/TerminalUserNamePasswordModule", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/TerminalUserNamePasswordModule", "<init>"));
        }
        super(runtime, executor);
    }

    @Override
    public boolean doHandlePrompt(String line, Key outputType) {
        return this.checkRealm(line) || this.checkUserName(line) || this.checkPassword(line);
    }

    private boolean checkRealm(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalUserNamePasswordModule", "checkRealm"));
        }
        Matcher matcher = AUTHENTICATION_REALM_MESSAGE.matcher(line);
        if (matcher.matches()) {
            this.realm = matcher.group(1);
        }
        return matcher.matches();
    }

    private boolean checkUserName(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalUserNamePasswordModule", "checkUserName"));
        }
        Matcher matcher = USER_NAME_PROMPT.matcher(line);
        return matcher.matches() && this.handleAuthPrompt(true);
    }

    private boolean checkPassword(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalUserNamePasswordModule", "checkPassword"));
        }
        Matcher matcher = PASSWORD_PROMPT.matcher(line);
        if (matcher.matches()) {
            this.userName = matcher.group(1);
        }
        return matcher.matches() && this.handleAuthPrompt(false);
    }

    private boolean handleAuthPrompt(boolean isUserName) {
        SVNURL repositoryUrl = this.myExecutor.getCommand().requireRepositoryUrl();
        if (this.needAskAuthentication(isUserName)) {
            this.authentication = (SVNPasswordAuthentication)this.myRuntime.getAuthenticationService().requestCredentials(repositoryUrl, "svn.simple");
        }
        return this.sendData(isUserName);
    }

    private boolean needAskAuthentication(boolean isUserName) {
        return this.authentication == null || isUserName && StringUtil.equals((CharSequence)this.userName, (CharSequence)this.authentication.getUserName());
    }

    private boolean sendData(boolean isUserName) {
        if (this.authentication != null) {
            this.sendData(isUserName ? this.authentication.getUserName() : this.authentication.getPassword());
        } else {
            this.cancelAuthentication();
        }
        return this.authentication != null;
    }
}

