/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vcs.CollectionSplitter;
import java.util.List;
import org.jetbrains.idea.svn.dialogs.PageEngine;

public class BasePageEngine<T>
implements PageEngine<List<T>> {
    private List<List<T>> mySplitData;
    private int myIdx;

    public BasePageEngine(List<T> data, int pageSize) {
        CollectionSplitter splitter = new CollectionSplitter(pageSize);
        this.mySplitData = splitter.split(data);
        this.myIdx = 0;
    }

    @Override
    public List<T> getCurrent() {
        return this.mySplitData.get(this.myIdx);
    }

    @Override
    public boolean hasNext() {
        return this.myIdx < this.mySplitData.size() - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.myIdx > 0;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.myIdx;
        return this.mySplitData.get(this.myIdx);
    }

    @Override
    public List<T> previous() {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.myIdx;
        return this.mySplitData.get(this.myIdx);
    }
}

