/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ValueHolder;
import com.intellij.util.continuation.TaskDescriptor;
import org.jetbrains.idea.svn.dialogs.RunOrContinuation;

public class FactsCalculator<In, Out, E extends Exception> {
    private final Project myProject;
    private final String myTaskTitle;
    private final ValueHolder<Out, In> myCache;
    private final ThrowableConvertor<In, Out, E> myLive;

    public FactsCalculator(Project project, String taskTitle, ValueHolder<Out, In> cache, ThrowableConvertor<In, Out, E> live) {
        this.myProject = project;
        this.myTaskTitle = taskTitle;
        this.myCache = cache;
        this.myLive = live;
    }

    public void get(In in, Consumer<TransparentlyFailedValueI<Out, E>> resultConsumer, Class<E> clazzE) {
        this.createRunOrContinuation(in, resultConsumer, clazzE).execute();
    }

    private RunOrContinuation<Out, E> createRunOrContinuation(final In in, final Consumer<TransparentlyFailedValueI<Out, E>> resultConsumer, Class<E> clazzE) {
        return new RunOrContinuation<Out, E>(this.myProject, this.myTaskTitle, clazzE){

            @Override
            protected Out calculate() {
                return FactsCalculator.this.myCache.getValue(in);
            }

            @Override
            protected Out calculateLong() throws Exception {
                Object result = FactsCalculator.this.myLive.convert(in);
                if (result != null) {
                    FactsCalculator.this.myCache.setValue(result, in);
                }
                return result;
            }

            @Override
            protected void processResult(TransparentlyFailedValueI<Out, E> t) {
                resultConsumer.consume(t);
            }
        };
    }

    public TaskDescriptor getTask(In in, Consumer<TransparentlyFailedValueI<Out, E>> resultConsumer, Class<E> clazzE) {
        return this.createRunOrContinuation(in, resultConsumer, clazzE).getTask();
    }
}

