/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.NotNullFunction;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import icons.SvnIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.AbstractIntegrateChangesAction;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnMergeInfoRootPanelManual;
import org.jetbrains.idea.svn.history.WcInfoLoader;
import org.jetbrains.idea.svn.integrate.ChangeListsMergerFactory;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.SelectedChangeListsChecker;
import org.jetbrains.idea.svn.integrate.SelectedCommittedStuffChecker;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoHolder;

public class RootsAndBranches
implements CommittedChangeListDecorator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.RootsAndBranches");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    private final DecoratorManager myManager;
    private final RepositoryLocation myLocation;
    private JPanel myPanel;
    private final Map<String, SvnMergeInfoRootPanelManual> myMergePanels;
    private final Map<String, MergeInfoHolder> myHolders;
    private boolean myHighlightingOn;
    private JPanel myPanelWrapper;
    private final MergePanelFiltering myStrategy;
    private final FilterOutMerged myFilterMerged;
    private final FilterOutNotMerged myFilterNotMerged;
    private final FilterOutAlien myFilterAlien;
    private final IntegrateChangeListsAction myIntegrateAction;
    private final IntegrateChangeListsAction myUndoIntegrateChangeListsAction;
    private JComponent myToolbarComponent;
    private boolean myDisposed;
    private final WcInfoLoader myDataLoader;
    public static final Topic<Runnable> REFRESH_REQUEST = new Topic("REFRESH_REQUEST", Runnable.class);

    private MergeInfoHolder getHolder(String key) {
        MergeInfoHolder holder = this.myHolders.get(key);
        if (holder != null) {
            return holder;
        }
        return this.myHolders.get(key.endsWith(File.separator) ? key.substring(0, key.length() - 1) : key + File.separator);
    }

    private SvnMergeInfoRootPanelManual getPanelData(String key) {
        SvnMergeInfoRootPanelManual panel = this.myMergePanels.get(key);
        if (panel != null) {
            return panel;
        }
        return this.myMergePanels.get(key.endsWith(File.separator) ? key.substring(0, key.length() - 1) : key + File.separator);
    }

    public RootsAndBranches(@NotNull SvnVcs vcs, @NotNull DecoratorManager manager, RepositoryLocation location) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/RootsAndBranches", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/idea/svn/history/RootsAndBranches", "<init>"));
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myManager = manager;
        this.myLocation = location;
        this.myDataLoader = new WcInfoLoader(this.myVcs, this.myLocation);
        this.myMergePanels = new HashMap<String, SvnMergeInfoRootPanelManual>();
        this.myHolders = new HashMap<String, MergeInfoHolder>();
        this.myFilterMerged = new FilterOutMerged();
        this.myFilterNotMerged = new FilterOutNotMerged();
        this.myFilterAlien = new FilterOutAlien();
        this.myIntegrateAction = new IntegrateChangeListsAction(true);
        this.myUndoIntegrateChangeListsAction = new IntegrateChangeListsAction(false);
        this.myPanel = new JPanel(new GridBagLayout());
        this.createToolbar();
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 0, (Insets)JBUI.insets((int)1), 0, 0);
        gb.insets = JBUI.insets((int)20, (int)1, (int)1, (int)1);
        this.myPanel.add((Component)new JLabel("Loading..."), gb);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)200, (int)60));
        this.myManager.install((CommittedChangeListDecorator)this);
        this.myStrategy = new MergePanelFiltering(this.getPanel());
    }

    public IntegrateChangeListsAction getIntegrateAction() {
        return this.myIntegrateAction;
    }

    public IntegrateChangeListsAction getUndoIntegrateAction() {
        return this.myUndoIntegrateChangeListsAction;
    }

    public boolean isHighlightingOn() {
        return this.myHighlightingOn;
    }

    public void reloadPanels() {
        final HashMap<Couple, SvnMergeInfoRootPanelManual.InfoHolder> states = new HashMap<Couple, SvnMergeInfoRootPanelManual.InfoHolder>();
        for (Map.Entry<String, SvnMergeInfoRootPanelManual> entry : this.myMergePanels.entrySet()) {
            String localPath = entry.getKey();
            WCInfoWithBranches wcInfo = entry.getValue().getWcInfo();
            states.put(Couple.of((Object)localPath, (Object)wcInfo.getUrl().toString()), entry.getValue().getInfo());
        }
        this.createPanels(this.myLocation, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : RootsAndBranches.this.myMergePanels.entrySet()) {
                    WCInfoWithBranches wcInfo;
                    String localPath = (String)entry.getKey();
                    Couple key = Couple.of((Object)localPath, (Object)(wcInfo = ((SvnMergeInfoRootPanelManual)entry.getValue()).getWcInfo()).getUrl().toString());
                    SvnMergeInfoRootPanelManual.InfoHolder infoHolder = (SvnMergeInfoRootPanelManual.InfoHolder)states.get(key);
                    if (infoHolder == null) continue;
                    ((SvnMergeInfoRootPanelManual)entry.getValue()).initSelection(infoHolder);
                }
            }
        });
    }

    public void turnFromHereHighlighting() {
        this.myHighlightingOn = true;
        for (MergeInfoHolder holder : this.myHolders.values()) {
            holder.updateMixedRevisionsForPanel();
        }
        this.myManager.repaintTree();
    }

    public void turnOff() {
        this.myHighlightingOn = false;
        for (SvnMergeInfoRootPanelManual panelManual : this.myMergePanels.values()) {
            panelManual.setMixedRevisions(false);
        }
        this.myManager.repaintTree();
    }

    public Icon decorate(CommittedChangeList list) {
        ListMergeStatus status = this.getStatus(list, false);
        return status == null ? ListMergeStatus.ALIEN.getIcon() : status.getIcon();
    }

    private void createPanels(RepositoryLocation location, final Runnable afterRefresh) {
        Task.Backgroundable backgroundable = new Task.Backgroundable(this.myProject, "Subversion: loading working copies data..", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/history/RootsAndBranches$2", "run"));
                }
                indicator.setIndeterminate(true);
                final HashMap panels = new HashMap();
                final HashMap holders = new HashMap();
                final List<WCInfoWithBranches> roots = RootsAndBranches.this.myDataLoader.loadRoots();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (RootsAndBranches.this.myDisposed) {
                            return;
                        }
                        JPanel mainPanel = RootsAndBranches.this.prepareData(panels, holders, roots);
                        RootsAndBranches.this.myMergePanels.clear();
                        RootsAndBranches.this.myHolders.clear();
                        RootsAndBranches.this.myMergePanels.putAll(panels);
                        RootsAndBranches.this.myHolders.putAll(holders);
                        if (RootsAndBranches.this.myPanelWrapper != null) {
                            RootsAndBranches.this.myPanelWrapper.removeAll();
                            if (RootsAndBranches.this.myMergePanels.isEmpty()) {
                                JPanel emptyPanel = new JPanel(new GridBagLayout());
                                GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
                                JLabel label = new JLabel("No Subversion 1.5 working copies\nof 1.5 repositories in the project");
                                label.setUI((LabelUI)new MultiLineLabelUI());
                                emptyPanel.add((Component)label, gb);
                                gb.fill = 2;
                                RootsAndBranches.this.myPanelWrapper.add((Component)emptyPanel, gb);
                            } else {
                                for (MergeInfoHolder holder : RootsAndBranches.this.myHolders.values()) {
                                    holder.updateMixedRevisionsForPanel();
                                }
                                RootsAndBranches.this.myPanelWrapper.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                            }
                            RootsAndBranches.this.myPanelWrapper.repaint();
                        } else {
                            RootsAndBranches.this.myPanel = mainPanel;
                        }
                        if (afterRefresh != null) {
                            afterRefresh.run();
                        }
                    }
                });
            }
        };
        ProgressManager.getInstance().run((Task)backgroundable);
    }

    public void refreshByLists(List<CommittedChangeList> committedChangeLists) {
        MergeInfoHolder holder;
        SvnChangeList svnList;
        String wcPath;
        if (!committedChangeLists.isEmpty() && (wcPath = (svnList = (SvnChangeList)committedChangeLists.get(0)).getWcPath()) != null && (holder = this.getHolder(wcPath)) != null) {
            holder.refresh(true);
        }
    }

    private void createToolbar() {
        DefaultActionGroup svnGroup = this.createActions();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)svnGroup, true);
        this.myToolbarComponent = actionToolbar.getComponent();
    }

    private JPanel prepareData(Map<String, SvnMergeInfoRootPanelManual> panels, Map<String, MergeInfoHolder> holders, List<WCInfoWithBranches> roots) {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        boolean onlyOneRoot = roots.size() == 1;
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
        mainPanel.add((Component)this.myToolbarComponent, gb);
        ++gb.gridy;
        for (final WCInfoWithBranches root : roots) {
            if (root == null) continue;
            SvnMergeInfoRootPanelManual panel = new SvnMergeInfoRootPanelManual(this.myProject, new NotNullFunction<WCInfoWithBranches, WCInfoWithBranches>(){

                @NotNull
                public WCInfoWithBranches fun(@NotNull WCInfoWithBranches wcInfoWithBranches) {
                    if (wcInfoWithBranches == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wcInfoWithBranches", "org/jetbrains/idea/svn/history/RootsAndBranches$3", "fun"));
                    }
                    WCInfoWithBranches newInfo = RootsAndBranches.this.myDataLoader.reloadInfo(wcInfoWithBranches);
                    if (newInfo == null) {
                        ((Runnable)RootsAndBranches.this.myProject.getMessageBus().syncPublisher(SvnVcs.WC_CONVERTED)).run();
                        WCInfoWithBranches wCInfoWithBranches = wcInfoWithBranches;
                        if (wCInfoWithBranches == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$3", "fun"));
                        }
                        return wCInfoWithBranches;
                    }
                    WCInfoWithBranches wCInfoWithBranches = newInfo;
                    if (wCInfoWithBranches == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$3", "fun"));
                    }
                    return wCInfoWithBranches;
                }
            }, new Runnable(){

                @Override
                public void run() {
                    MergeInfoHolder holder = RootsAndBranches.this.getHolder(root.getPath());
                    if (holder != null) {
                        holder.refresh(false);
                    }
                }
            }, onlyOneRoot, root);
            panels.put(root.getPath(), panel);
            holders.put(root.getPath(), this.createHolder(panel));
            JPanel contentPanel = panel.getContentPanel();
            mainPanel.add((Component)contentPanel, gb);
            ++gb.gridy;
        }
        if (panels.size() == 1) {
            for (SvnMergeInfoRootPanelManual panel : panels.values()) {
                panel.setOnlyOneRoot(true);
            }
        }
        return mainPanel;
    }

    private DefaultActionGroup createActions() {
        DefaultActionGroup svnGroup = new DefaultActionGroup();
        svnGroup.add((AnAction)new HighlightFrom());
        svnGroup.add((AnAction)this.myIntegrateAction);
        svnGroup.add((AnAction)this.myUndoIntegrateChangeListsAction);
        svnGroup.add((AnAction)new MarkAsMerged(true));
        svnGroup.add((AnAction)new MarkAsMerged(false));
        svnGroup.add((AnAction)this.myFilterMerged);
        svnGroup.add((AnAction)this.myFilterNotMerged);
        svnGroup.add((AnAction)this.myFilterAlien);
        svnGroup.add(ActionManager.getInstance().getAction("Svn.Show.Working.Copies"));
        svnGroup.add((AnAction)new MyRefresh());
        return svnGroup;
    }

    @NotNull
    private MergeInfoHolder createHolder(@NotNull SvnMergeInfoRootPanelManual panel) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/idea/svn/history/RootsAndBranches", "createHolder"));
        }
        MergeInfoHolder mergeInfoHolder = new MergeInfoHolder(this.myProject, this.myManager, this, panel);
        if (mergeInfoHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches", "createHolder"));
        }
        return mergeInfoHolder;
    }

    public JComponent getPanel() {
        this.myPanelWrapper = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension oldSize = super.getPreferredSize();
                oldSize.width = 200;
                return oldSize;
            }
        };
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.myPanelWrapper.add((Component)this.myPanel, gb);
        return ScrollPaneFactory.createScrollPane((Component)this.myPanelWrapper, (int)20, (int)30);
    }

    private String ensureEndsWithSeparator(String wcPath) {
        return wcPath.endsWith(File.separator) ? wcPath : wcPath + File.separator;
    }

    public void refresh() {
        final HashMap<String, CommittedChangeListsListener> refreshers = new HashMap<String, CommittedChangeListsListener>();
        for (Map.Entry<String, MergeInfoHolder> entry : this.myHolders.entrySet()) {
            CommittedChangeListsListener refresher = entry.getValue().createRefresher(false);
            if (refresher == null) continue;
            refreshers.put(this.ensureEndsWithSeparator(entry.getKey()), refresher);
        }
        if (!refreshers.isEmpty()) {
            this.myManager.reportLoadedLists(new CommittedChangeListsListener(){

                public void onBeforeStartReport() {
                }

                public boolean report(CommittedChangeList list) {
                    CommittedChangeListsListener refresher;
                    SvnChangeList svnList;
                    String wcPath;
                    if (list instanceof SvnChangeList && (wcPath = (svnList = (SvnChangeList)list).getWcPath()) != null && (refresher = (CommittedChangeListsListener)refreshers.get(RootsAndBranches.this.ensureEndsWithSeparator(wcPath))) != null) {
                        refresher.report(list);
                    }
                    return true;
                }

                public void onAfterEndReport() {
                    for (CommittedChangeListsListener refresher : refreshers.values()) {
                        refresher.onAfterEndReport();
                    }
                    RootsAndBranches.this.myStrategy.notifyListener();
                }
            });
            this.myManager.repaintTree();
        }
    }

    private boolean mergeEnabled(List<CommittedChangeList> listsList, boolean forMerge) {
        if (listsList == null || listsList.isEmpty()) {
            return false;
        }
        for (CommittedChangeList list : listsList) {
            if (this.mergeEnabled(list, forMerge)) continue;
            return false;
        }
        return true;
    }

    private boolean mergeEnabled(CommittedChangeList list, boolean forMerge) {
        ListMergeStatus mergeStatus = this.getStatus(list, true);
        if (mergeStatus == null || ListMergeStatus.ALIEN.equals((Object)mergeStatus)) {
            return false;
        }
        if (ListMergeStatus.REFRESHING.equals((Object)mergeStatus)) {
            return true;
        }
        if (forMerge) {
            return ListMergeStatus.NOT_MERGED.equals((Object)mergeStatus);
        }
        return ListMergeStatus.MERGED.equals((Object)mergeStatus);
    }

    private SvnMergeInfoRootPanelManual getPanelData(List<CommittedChangeList> listsList) {
        for (CommittedChangeList list : listsList) {
            if (!(list instanceof SvnChangeList)) {
                return null;
            }
            SvnChangeList svnList = (SvnChangeList)list;
            String wcPath = svnList.getWcPath();
            if (wcPath == null) continue;
            return this.getPanelData(wcPath);
        }
        return null;
    }

    @Nullable
    public ListMergeStatus getStatus(CommittedChangeList list, boolean ignoreEnabled) {
        if (!(list instanceof SvnChangeList)) {
            return null;
        }
        SvnChangeList svnList = (SvnChangeList)list;
        String wcPath = svnList.getWcPath();
        MergeInfoHolder holder = null;
        if (wcPath == null) {
            for (Map.Entry<String, SvnMergeInfoRootPanelManual> entry : this.myMergePanels.entrySet()) {
                SvnMergeInfoRootPanelManual panelManual = entry.getValue();
                if (panelManual.getBranch() == null || panelManual.getBranch().getUrl() == null || !svnList.allPathsUnder(panelManual.getBranch().getUrl())) continue;
                holder = this.getHolder(entry.getKey());
            }
        } else {
            holder = this.getHolder(wcPath);
        }
        if (holder != null) {
            return holder.check(list, ignoreEnabled);
        }
        return null;
    }

    public MergePanelFiltering getStrategy() {
        return this.myStrategy;
    }

    public boolean strategyInitialized() {
        return this.myStrategy.isInitialized();
    }

    public void fireRepaint() {
        this.myManager.repaintTree();
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private class MergePanelFiltering
    implements ChangeListFilteringStrategy {
        private final JComponent myPanel;
        private ChangeListener myListener;
        private boolean myInitialized;
        private static final String ourKey = "MERGE_PANEL";

        public MergePanelFiltering(JComponent panel) {
            this.myPanel = panel;
        }

        public boolean isInitialized() {
            return this.myInitialized;
        }

        public JComponent getFilterUI() {
            if (!this.myInitialized) {
                RootsAndBranches.this.createPanels(RootsAndBranches.this.myLocation, null);
            }
            this.myInitialized = true;
            return this.myPanel;
        }

        public CommittedChangesFilterKey getKey() {
            return new CommittedChangesFilterKey(ourKey, CommittedChangesFilterPriority.MERGE);
        }

        public void setFilterBase(List<CommittedChangeList> changeLists) {
        }

        public void addChangeListener(ChangeListener listener) {
            this.myListener = listener;
        }

        public void removeChangeListener(ChangeListener listener) {
            this.myListener = null;
        }

        public void resetFilterBase() {
        }

        public void appendFilterBase(List<CommittedChangeList> changeLists) {
        }

        @NotNull
        public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
            if (!(RootsAndBranches.this.myFilterAlien.isSelected(null) || RootsAndBranches.this.myFilterNotMerged.isSelected(null) || RootsAndBranches.this.myFilterMerged.isSelected(null))) {
                List<CommittedChangeList> list = changeLists;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$MergePanelFiltering", "filterChangeLists"));
                }
                return list;
            }
            ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
            for (CommittedChangeList list : changeLists) {
                ListMergeStatus status = RootsAndBranches.this.getStatus(list, true);
                if (ListMergeStatus.REFRESHING.equals((Object)status)) {
                    result.add(list);
                    continue;
                }
                if (status == null || ListMergeStatus.ALIEN.equals((Object)status)) {
                    if (RootsAndBranches.this.myFilterAlien.isSelected(null)) continue;
                    result.add(list);
                    continue;
                }
                if (ListMergeStatus.MERGED.equals((Object)status) || ListMergeStatus.COMMON.equals((Object)status)) {
                    if (RootsAndBranches.this.myFilterMerged.isSelected(null)) continue;
                    result.add(list);
                    continue;
                }
                if (RootsAndBranches.this.myFilterNotMerged.isSelected(null)) continue;
                result.add(list);
            }
            ArrayList<CommittedChangeList> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$MergePanelFiltering", "filterChangeLists"));
            }
            return arrayList;
        }

        public void notifyListener() {
            if (this.myListener != null) {
                this.myListener.stateChanged(new ChangeEvent(this));
            }
            RootsAndBranches.this.myManager.repaintTree();
        }
    }

    private class IntegrateChangeListsAction
    extends AbstractIntegrateChangesAction<SelectedChangeListsChecker> {
        private final boolean myIntegrate;

        public IntegrateChangeListsAction(boolean integrate) {
            super(false);
            this.myIntegrate = integrate;
        }

        @Override
        @NotNull
        protected MergerFactory createMergerFactory(SelectedChangeListsChecker checker) {
            ChangeListsMergerFactory changeListsMergerFactory = new ChangeListsMergerFactory(checker.getSelectedLists(), false, !this.myIntegrate, false);
            if (changeListsMergerFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$IntegrateChangeListsAction", "createMergerFactory"));
            }
            return changeListsMergerFactory;
        }

        @Override
        @NotNull
        protected SelectedChangeListsChecker createChecker() {
            SelectedChangeListsChecker selectedChangeListsChecker = new SelectedChangeListsChecker();
            if (selectedChangeListsChecker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$IntegrateChangeListsAction", "createChecker"));
            }
            return selectedChangeListsChecker;
        }

        @Override
        protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
            if (this.myIntegrate) {
                e.getPresentation().setIcon(SvnIcons.IntegrateToBranch);
            } else {
                e.getPresentation().setIcon(SvnIcons.UndoIntegrateToBranch);
                e.getPresentation().setText(SvnBundle.message("undo.integrate.to.branch", new Object[0]));
                e.getPresentation().setDescription(SvnBundle.message("undo.integrate.to.branch.description", new Object[0]));
            }
        }

        @Override
        protected String getSelectedBranchUrl(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null && data.getBranch() != null) {
                return data.getBranch().getUrl();
            }
            return null;
        }

        @Override
        protected String getSelectedBranchLocalPath(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getLocalBranch();
            }
            return null;
        }

        @Override
        protected String getDialogTitle() {
            return !this.myIntegrate ? SvnBundle.message("undo.integrate.to.branch.dialog.title", new Object[0]) : null;
        }
    }

    private class MarkAsMerged
    extends AbstractIntegrateChangesAction<SelectedChangeListsChecker> {
        private final String myText;
        private final String myDescription;
        private final boolean myMarkAsMerged;

        private MarkAsMerged(boolean markAsMerged) {
            super(false);
            this.myMarkAsMerged = markAsMerged;
            this.myText = this.message("action.mark.list.as.%s.text");
            this.myDescription = this.message("action.mark.list.as.%s.description");
        }

        @Override
        @NotNull
        protected MergerFactory createMergerFactory(SelectedChangeListsChecker checker) {
            ChangeListsMergerFactory changeListsMergerFactory = new ChangeListsMergerFactory(checker.getSelectedLists(), true, !this.myMarkAsMerged, false);
            if (changeListsMergerFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsMerged", "createMergerFactory"));
            }
            return changeListsMergerFactory;
        }

        @Override
        @NotNull
        protected SelectedChangeListsChecker createChecker() {
            SelectedChangeListsChecker selectedChangeListsChecker = new SelectedChangeListsChecker();
            if (selectedChangeListsChecker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsMerged", "createChecker"));
            }
            return selectedChangeListsChecker;
        }

        @Override
        protected void updateWithChecker(AnActionEvent e, SelectedCommittedStuffChecker checker) {
            Presentation presentation = e.getPresentation();
            presentation.setIcon(this.myMarkAsMerged ? SvnIcons.MarkAsMerged : SvnIcons.MarkAsNotMerged);
            presentation.setText(this.myText);
            presentation.setDescription(this.myDescription);
            presentation.setEnabled(presentation.isEnabled() && RootsAndBranches.this.mergeEnabled(checker.getSelectedLists(), this.myMarkAsMerged));
        }

        @Override
        @Nullable
        protected String getSelectedBranchUrl(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getBranch().getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        protected String getSelectedBranchLocalPath(SelectedCommittedStuffChecker checker) {
            SvnMergeInfoRootPanelManual data = RootsAndBranches.this.getPanelData(checker.getSelectedLists());
            if (data != null) {
                return data.getLocalBranch();
            }
            return null;
        }

        @Override
        protected String getDialogTitle() {
            return this.myText;
        }

        @NotNull
        private String message(@NotNull String key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsMerged", "message"));
            }
            String string = SvnBundle.message(String.format(key, this.myMarkAsMerged ? "merged" : "not.merged"), new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/RootsAndBranches$MarkAsMerged", "message"));
            }
            return string;
        }
    }

    private class FilterOutAlien
    extends CommonFilter {
        private FilterOutAlien() {
            super(SvnIcons.FilterOthers, SvnBundle.message("tab.repository.merge.panel.filter.others", new Object[0]));
        }
    }

    private class FilterOutNotMerged
    extends CommonFilter {
        private FilterOutNotMerged() {
            super(SvnIcons.FilterNotIntegrated, SvnBundle.message("tab.repository.merge.panel.filter.minus", new Object[0]));
        }
    }

    private class FilterOutMerged
    extends CommonFilter {
        private FilterOutMerged() {
            super(SvnIcons.FilterIntegrated, SvnBundle.message("tab.repository.merge.panel.filter.plus", new Object[0]));
        }
    }

    private abstract class CommonFilter
    extends ToggleAction {
        private boolean mySelected;
        private final Icon myIcon;

        protected CommonFilter(Icon icon, String text) {
            super(text);
            this.myIcon = icon;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(RootsAndBranches.this.myHighlightingOn);
            presentation.setIcon(this.myIcon);
            presentation.setText(this.getTemplatePresentation().getText());
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySelected;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySelected = state;
            RootsAndBranches.this.myStrategy.notifyListener();
        }
    }

    private class HighlightFrom
    extends ToggleAction {
        private HighlightFrom() {
        }

        public void update(AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setIcon(SvnIcons.ShowIntegratedFrom);
            presentation.setText(SvnBundle.message("committed.changes.action.enable.merge.highlighting", new Object[0]));
            presentation.setDescription(SvnBundle.message("committed.changes.action.enable.merge.highlighting.description.text", new Object[0]));
        }

        public boolean isSelected(AnActionEvent e) {
            return RootsAndBranches.this.myHighlightingOn;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                RootsAndBranches.this.turnFromHereHighlighting();
            } else {
                RootsAndBranches.this.turnOff();
            }
        }
    }

    private class MyRefresh
    extends AnAction {
        private MyRefresh() {
            super(SvnBundle.message("committed.changes.action.merge.highlighting.refresh.text", new Object[0]), SvnBundle.message("committed.changes.action.merge.highlighting.refresh.description", new Object[0]), AllIcons.Actions.Refresh);
        }

        public void update(AnActionEvent e) {
            for (MergeInfoHolder holder : RootsAndBranches.this.myHolders.values()) {
                if (!holder.refreshEnabled(false)) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            RootsAndBranches.this.refresh();
        }
    }
}

