/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.vcs.CheckSamePattern;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.SelectedCommittedStuffChecker;
import org.tmatesoft.svn.core.SVNURL;

public class SelectedChangeListsChecker
implements SelectedCommittedStuffChecker {
    protected final List<CommittedChangeList> myChangeListsList = new ArrayList<CommittedChangeList>();
    private boolean isValid;
    private SVNURL mySameBranch;
    private VirtualFile myVcsRoot;

    @Override
    public void execute(AnActionEvent event) {
        this.isValid = false;
        this.myChangeListsList.clear();
        this.getSelectedSvnCls(event);
        if (!this.myChangeListsList.isEmpty()) {
            this.checkSame();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public List<CommittedChangeList> getSelectedLists() {
        return this.myChangeListsList;
    }

    private void checkSame() {
        CheckSamePattern sameBranch = new CheckSamePattern();
        CheckSamePattern sameRoot = new CheckSamePattern();
        for (ChangeList changeList : this.myChangeListsList) {
            SvnChangeList svnChangeList = (SvnChangeList)changeList;
            sameBranch.iterate((Object)svnChangeList.getBranchUrl());
            sameRoot.iterate((Object)svnChangeList.getRoot());
            if (sameBranch.isSame() && sameRoot.isSame()) continue;
            break;
        }
        this.isValid = sameBranch.isSame() && sameRoot.isSame();
        this.mySameBranch = (SVNURL)sameBranch.getSameValue();
        this.myVcsRoot = (VirtualFile)sameRoot.getSameValue();
    }

    @Override
    public SVNURL getSameBranch() {
        return this.mySameBranch;
    }

    @Override
    public VirtualFile getRoot() {
        return this.myVcsRoot;
    }

    private void getSelectedSvnCls(AnActionEvent event) {
        ChangeList[] cls = (ChangeList[])event.getData(VcsDataKeys.CHANGE_LISTS);
        if (cls != null) {
            for (ChangeList cl : cls) {
                CommittedChangeList committed = (CommittedChangeList)cl;
                if (committed == null || committed.getVcs() == null || !"svn".equals(committed.getVcs().getName())) continue;
                this.myChangeListsList.add(committed);
            }
        }
    }
}

