/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.RecursiveFormNestingException;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.LwAtomicComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwHSpacer;
import com.intellij.uiDesigner.lw.LwIntrospectedProperty;
import com.intellij.uiDesigner.lw.LwNestedForm;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.LwScrollPane;
import com.intellij.uiDesigner.lw.LwSplitPane;
import com.intellij.uiDesigner.lw.LwTabbedPane;
import com.intellij.uiDesigner.lw.LwToolBar;
import com.intellij.uiDesigner.lw.LwVSpacer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.make.PsiNestedFormLoader;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.radComponents.LayoutManagerRegistry;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadNestedForm;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadScrollPane;
import com.intellij.uiDesigner.radComponents.RadSplitPane;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.uiDesigner.radComponents.RadTable;
import com.intellij.uiDesigner.radComponents.RadToolBar;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.uiDesigner.radComponents.XYLayoutManagerImpl;
import com.intellij.uiDesigner.shared.XYLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public final class XmlReader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.XmlReader");

    private XmlReader() {
    }

    @NotNull
    public static RadRootContainer createRoot(ModuleProvider module, LwRootContainer lwRootContainer, ClassLoader loader, Locale stringDescriptorLocale) throws Exception {
        RadRootContainer radRootContainer = (RadRootContainer)XmlReader.createComponent(module, (LwComponent)lwRootContainer, loader, stringDescriptorLocale);
        if (radRootContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/XmlReader", "createRoot"));
        }
        return radRootContainer;
    }

    @NotNull
    public static RadComponent createComponent(@NotNull ModuleProvider module, @NotNull LwComponent lwComponent, @NotNull ClassLoader loader, Locale stringDescriptorLocale) throws Exception {
        RadComponent component;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/uiDesigner/XmlReader", "createComponent"));
        }
        if (lwComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lwComponent", "com/intellij/uiDesigner/XmlReader", "createComponent"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/uiDesigner/XmlReader", "createComponent"));
        }
        String id = lwComponent.getId();
        Class<?> componentClass = null;
        if (lwComponent instanceof LwNestedForm) {
            LwNestedForm nestedForm = (LwNestedForm)lwComponent;
            boolean recursiveNesting = false;
            try {
                Utils.validateNestedFormLoop((String)nestedForm.getFormFileName(), (NestedFormLoader)new PsiNestedFormLoader(module.getModule()));
            }
            catch (RecursiveFormNestingException ex) {
                recursiveNesting = true;
            }
            component = recursiveNesting ? RadErrorComponent.create(module, id, lwComponent.getComponentClassName(), lwComponent.getErrorComponentProperties(), UIDesignerBundle.message("error.recursive.form.nesting", new Object[0])) : new RadNestedForm(module, nestedForm.getFormFileName(), id);
        } else {
            if (lwComponent.getErrorComponentProperties() == null) {
                componentClass = Class.forName(lwComponent.getComponentClassName(), true, loader);
            }
            if (lwComponent instanceof LwHSpacer) {
                component = new RadHSpacer(module, id);
            } else if (lwComponent instanceof LwVSpacer) {
                component = new RadVSpacer(module, id);
            } else if (lwComponent instanceof LwAtomicComponent) {
                if (componentClass == null) {
                    component = XmlReader.createErrorComponent(module, id, lwComponent, loader);
                } else {
                    RadAtomicComponent component1;
                    try {
                        component1 = JTable.class.isAssignableFrom(componentClass) ? new RadTable(module, componentClass, id) : new RadAtomicComponent(module, componentClass, id);
                    }
                    catch (Exception exc) {
                        String errorDescription = MessageFormat.format(UIDesignerBundle.message("error.class.cannot.be.instantiated", new Object[0]), lwComponent.getComponentClassName());
                        String string = FormEditingUtil.getExceptionMessage(exc);
                        if (string != null) {
                            errorDescription = errorDescription + ": " + string;
                        }
                        component1 = RadErrorComponent.create(module, id, lwComponent.getComponentClassName(), lwComponent.getErrorComponentProperties(), errorDescription);
                    }
                    component = component1;
                }
            } else if (lwComponent instanceof LwScrollPane) {
                component = new RadScrollPane(module, componentClass, id);
            } else if (lwComponent instanceof LwTabbedPane) {
                component = new RadTabbedPane(module, componentClass, id);
            } else if (lwComponent instanceof LwSplitPane) {
                component = new RadSplitPane(module, componentClass, id);
            } else if (lwComponent instanceof LwToolBar) {
                component = new RadToolBar(module, componentClass, id);
            } else if (lwComponent instanceof LwContainer) {
                LwContainer lwContainer = (LwContainer)lwComponent;
                Object layout = lwContainer.getLayout();
                if (layout instanceof XYLayoutManager) {
                    XYLayoutManagerImpl xyLayoutManager = new XYLayoutManagerImpl();
                    layout = xyLayoutManager;
                    xyLayoutManager.setPreferredSize(lwComponent.getBounds().getSize());
                }
                if (componentClass == null) {
                    component = XmlReader.createErrorComponent(module, id, lwComponent, loader);
                } else {
                    if (lwContainer instanceof LwRootContainer) {
                        component = new RadRootContainer(module, id);
                        if (stringDescriptorLocale != null) {
                            ((RadRootContainer)component).setStringDescriptorLocale(stringDescriptorLocale);
                        }
                    } else {
                        component = new RadContainer(module, componentClass, id);
                        Object layoutManagerName = lwContainer.getLayoutManager();
                        if (layoutManagerName == null || ((String)layoutManagerName).length() == 0) {
                            layoutManagerName = layout instanceof XYLayoutManager ? "XYLayout" : "GridLayoutManager";
                        }
                        RadLayoutManager radLayoutManager = LayoutManagerRegistry.createLayoutManager((String)layoutManagerName);
                        RadContainer container = (RadContainer)component;
                        radLayoutManager.readLayout(lwContainer, container);
                        container.setLayoutManager(radLayoutManager);
                    }
                    ((RadContainer)component).setLayout((LayoutManager)layout);
                }
            } else {
                throw new IllegalArgumentException("unexpected component: " + lwComponent);
            }
        }
        component.setBinding(lwComponent.getBinding());
        component.setCustomCreate(lwComponent.isCustomCreate());
        component.setDefaultBinding(lwComponent.isDefaultBinding());
        component.setBounds(lwComponent.getBounds());
        if (stringDescriptorLocale != null) {
            component.putClientProperty("LoadTimeLocaleKey", stringDescriptorLocale);
        }
        LwIntrospectedProperty[] properties = lwComponent.getAssignedIntrospectedProperties();
        if (componentClass != null) {
            Palette palette = Palette.getInstance(module.getProject());
            for (LwIntrospectedProperty lwProperty : properties) {
                IntrospectedProperty property = palette.getIntrospectedProperty(component, lwProperty.getName());
                if (property == null) continue;
                component.loadLwProperty(lwComponent, lwProperty, property);
            }
        }
        component.getConstraints().restore(lwComponent.getConstraints());
        component.setCustomLayoutConstraints(lwComponent.getCustomLayoutConstraints());
        HashMap clientProps = lwComponent.getDelegeeClientProperties();
        for (Object e : clientProps.entrySet()) {
            Map.Entry entry = (Map.Entry)e;
            Object value = entry.getValue();
            if (value instanceof StringDescriptor) {
                value = ((StringDescriptor)value).getValue();
            }
            component.getDelegee().putClientProperty(entry.getKey(), value);
        }
        if (component instanceof RadContainer) {
            RadContainer container = (RadContainer)component;
            LwContainer lwContainer = (LwContainer)lwComponent;
            XmlReader.copyBorder(container, lwContainer);
            for (int i = 0; i < lwContainer.getComponentCount(); ++i) {
                container.addComponent(XmlReader.createComponent(module, (LwComponent)lwContainer.getComponent(i), loader, stringDescriptorLocale));
            }
        }
        if (component instanceof RadRootContainer) {
            RadRootContainer radRootContainer = (RadRootContainer)component;
            LwRootContainer lwRootContainer = (LwRootContainer)lwComponent;
            radRootContainer.setClassToBind(lwRootContainer.getClassToBind());
            radRootContainer.setMainComponentBinding(lwRootContainer.getMainComponentBinding());
            radRootContainer.setButtonGroups(lwRootContainer.getButtonGroups());
            radRootContainer.setInspectionSuppressions(lwRootContainer.getInspectionSuppressions());
            radRootContainer.getDelegee().setBackground((Color)new JBColor(Color.WHITE, UIUtil.getListBackground()));
        }
        component.doneLoadingFromLw();
        component.putClientProperty("LoadTimeLocaleKey", null);
        RadComponent radComponent = component;
        if (radComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/XmlReader", "createComponent"));
        }
        return radComponent;
    }

    private static void copyBorder(RadContainer container, LwContainer lwContainer) {
        container.setBorderType(lwContainer.getBorderType());
        container.setBorderTitle(lwContainer.getBorderTitle());
        container.setBorderTitleJustification(lwContainer.getBorderTitleJustification());
        container.setBorderTitlePosition(lwContainer.getBorderTitlePosition());
        container.setBorderTitleFont(lwContainer.getBorderTitleFont());
        container.setBorderTitleColor(lwContainer.getBorderTitleColor());
        container.setBorderSize(lwContainer.getBorderSize());
        container.setBorderColor(lwContainer.getBorderColor());
    }

    private static RadErrorComponent createErrorComponent(ModuleProvider module, String id, LwComponent lwComponent, ClassLoader loader) {
        String componentClassName = lwComponent.getComponentClassName();
        String errorDescription = Utils.validateJComponentClass((ClassLoader)loader, (String)componentClassName, (boolean)true);
        return RadErrorComponent.create(module, id, lwComponent.getComponentClassName(), lwComponent.getErrorComponentProperties(), errorDescription != null ? errorDescription : UIDesignerBundle.message("error.cannot.load.class", componentClassName));
    }
}

