/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.uiDesigner.CaptionSelection;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.actions.RowColumnAction;
import com.jgoodies.forms.layout.FormLayout;
import java.util.ArrayList;

public class GroupRowsColumnsAction
extends RowColumnAction {
    public GroupRowsColumnsAction() {
        super(UIDesignerBundle.message("action.group.columns", new Object[0]), null, UIDesignerBundle.message("action.group.rows", new Object[0]), null);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        CaptionSelection selection = (CaptionSelection)CaptionSelection.DATA_KEY.getData(e.getDataContext());
        if (selection != null) {
            e.getPresentation().setEnabled(selection.getContainer() != null && selection.getContainer().getLayout() instanceof FormLayout && GroupRowsColumnsAction.getCellsToGroup(selection).length > 1 && !GroupRowsColumnsAction.isGrouped(selection));
        }
    }

    public static boolean isGrouped(CaptionSelection selection) {
        FormLayout layout = (FormLayout)selection.getContainer().getLayout();
        int[][] groups = selection.isRow() ? layout.getRowGroups() : layout.getColumnGroups();
        int[] indices = selection.getSelection();
        for (int[] group : groups) {
            if (!GroupRowsColumnsAction.intersect(group, indices)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersect(int[] group, int[] indices) {
        for (int groupMember : group) {
            for (int index : indices) {
                if (groupMember != index + 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void actionPerformed(CaptionSelection selection) {
        FormLayout layout = (FormLayout)selection.getContainer().getLayout();
        int[][] oldGroups = selection.isRow() ? layout.getRowGroups() : layout.getColumnGroups();
        int[][] newGroups = new int[oldGroups.length + 1][];
        System.arraycopy(oldGroups, 0, newGroups, 0, oldGroups.length);
        int[] cellsToGroup = GroupRowsColumnsAction.getCellsToGroup(selection);
        newGroups[oldGroups.length] = new int[cellsToGroup.length];
        for (int i = 0; i < cellsToGroup.length; ++i) {
            newGroups[oldGroups.length][i] = cellsToGroup[i] + 1;
        }
        if (selection.isRow()) {
            layout.setRowGroups((int[][])newGroups);
        } else {
            layout.setColumnGroups((int[][])newGroups);
        }
    }

    private static int[] getCellsToGroup(CaptionSelection selection) {
        int[] selectedIndices;
        ArrayList<Integer> cells = new ArrayList<Integer>();
        for (int i : selectedIndices = selection.getSelection()) {
            if (selection.getContainer().getGridLayoutManager().isGapCell(selection.getContainer(), selection.isRow(), i)) continue;
            cells.add(i);
        }
        int[] result = new int[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            result[i] = (Integer)cells.get(i);
        }
        return result;
    }
}

