/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.Navigatable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.snapShooter.SnapShooter;
import com.intellij.uiDesigner.snapShooter.SnapShooterConfigurationSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.xml.util.XmlStringUtil;
import com.jgoodies.forms.layout.FormLayout;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SnapShooterConfigurationExtension
extends RunConfigurationExtension {
    public void updateJavaParameters(RunConfigurationBase configuration, JavaParameters params, RunnerSettings runnerSettings) {
        if (!this.isApplicableFor(configuration)) {
            return;
        }
        ApplicationConfiguration appConfiguration = (ApplicationConfiguration)configuration;
        SnapShooterConfigurationSettings settings = (SnapShooterConfigurationSettings)appConfiguration.getUserData(SnapShooterConfigurationSettings.SNAP_SHOOTER_KEY);
        if (settings == null) {
            settings = new SnapShooterConfigurationSettings();
            appConfiguration.putUserData(SnapShooterConfigurationSettings.SNAP_SHOOTER_KEY, (Object)settings);
        }
        if (appConfiguration.ENABLE_SWING_INSPECTOR) {
            settings.setLastPort(NetUtils.tryToFindAvailableSocketPort());
        }
        if (appConfiguration.ENABLE_SWING_INSPECTOR && settings.getLastPort() != -1) {
            params.getProgramParametersList().prepend(appConfiguration.MAIN_CLASS_NAME);
            params.getProgramParametersList().prepend(Integer.toString(settings.getLastPort()));
            params.getProgramParametersList().prepend(Integer.toString(params.getClassPath().getPathList().size() + 1));
            TreeSet<String> paths = new TreeSet<String>();
            paths.add(PathUtil.getJarPathForClass(SnapShooter.class));
            paths.add(PathUtil.getJarPathForClass(BaseComponent.class));
            paths.add(PathUtil.getJarPathForClass(ProjectComponent.class));
            paths.add(PathUtil.getJarPathForClass(DesignerEditorPanelFacade.class));
            paths.add(PathUtil.getJarPathForClass(LwComponent.class));
            paths.add(PathUtil.getJarPathForClass(GridConstraints.class));
            paths.add(PathUtil.getJarPathForClass(PaletteGroup.class));
            paths.add(PathUtil.getJarPathForClass(LafManagerListener.class));
            paths.add(PathUtil.getJarPathForClass(DataProvider.class));
            paths.add(PathUtil.getJarPathForClass(XmlStringUtil.class));
            paths.add(PathUtil.getJarPathForClass(Navigatable.class));
            paths.add(PathUtil.getJarPathForClass(AreaInstance.class));
            paths.add(PathUtil.getJarPathForClass(FormLayout.class));
            paths.addAll(PathManager.getUtilClassPath());
            for (String path : paths) {
                params.getClassPath().addFirst(path);
            }
            params.setMainClass("com.intellij.uiDesigner.snapShooter.SnapShooter");
        }
    }

    protected boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "isApplicableFor"));
        }
        return configuration instanceof ApplicationConfiguration;
    }

    public void attachToProcess(@NotNull RunConfigurationBase configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        Runnable runnable;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "attachToProcess"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "attachToProcess"));
        }
        SnapShooterConfigurationSettings settings = (SnapShooterConfigurationSettings)configuration.getUserData(SnapShooterConfigurationSettings.SNAP_SHOOTER_KEY);
        if (settings != null && (runnable = settings.getNotifyRunnable()) != null) {
            settings.setNotifyRunnable(null);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    runnable.run();
                }
            });
        }
    }

    public SettingsEditor createEditor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "createEditor"));
        }
        return null;
    }

    public String getEditorTitle() {
        return null;
    }

    @NotNull
    public String getSerializationId() {
        if ("snapshooter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "getSerializationId"));
        }
        return "snapshooter";
    }

    public void readExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "readExternal"));
        }
    }

    public void writeExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "writeExternal"));
        }
        throw new WriteExternalException();
    }

    public void extendCreatedConfiguration(@NotNull RunConfigurationBase runJavaConfiguration, @NotNull Location location) {
        if (runJavaConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runJavaConfiguration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "extendCreatedConfiguration"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "extendCreatedConfiguration"));
        }
    }

    public void validateConfiguration(@NotNull RunConfigurationBase runJavaConfiguration, boolean isExecution) throws RuntimeConfigurationException {
        if (runJavaConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runJavaConfiguration", "com/intellij/uiDesigner/snapShooter/SnapShooterConfigurationExtension", "validateConfiguration"));
        }
    }
}

