/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.wizard.BeanProperty;
import java.awt.Color;
import javax.swing.JTable;

final class BeanPropertyTableCellRenderer
extends ColoredTableCellRenderer {
    private final SimpleTextAttributes myAttrs1 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
    private final SimpleTextAttributes myAttrs2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
    private final SimpleTextAttributes myAttrs3 = new SimpleTextAttributes(0, Color.GRAY);

    BeanPropertyTableCellRenderer() {
    }

    protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
        BeanProperty property = (BeanProperty)value;
        if (property == null) {
            this.append(UIDesignerBundle.message("property.not.defined", new Object[0]), this.myAttrs2);
        } else {
            String packageName;
            String shortClassName;
            this.append(property.myName, this.myAttrs1);
            this.append(" ", this.myAttrs1);
            int lastDotIndex = property.myType.lastIndexOf(46);
            if (lastDotIndex != -1) {
                shortClassName = property.myType.substring(lastDotIndex + 1);
                packageName = property.myType.substring(0, lastDotIndex);
            } else {
                shortClassName = property.myType;
                packageName = null;
            }
            this.append(shortClassName, this.myAttrs2);
            if (packageName != null) {
                this.append(" (", this.myAttrs3);
                this.append(packageName, this.myAttrs3);
                this.append(")", this.myAttrs3);
            }
        }
    }
}

