/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.pattern.FileUtil;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateCopyrightAction
extends BaseAnalysisAction {
    public static final String UPDATE_EXISTING_COPYRIGHTS = "update.existing.copyrights";
    private JCheckBox myUpdateExistingCopyrightsCb;

    protected UpdateCopyrightAction() {
        super("Update Copyright", "Update Copyright");
    }

    public void update(AnActionEvent event) {
        boolean enabled = UpdateCopyrightAction.isEnabled(event);
        event.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(enabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        PsiElement[] elems;
        DataContext context = e.getDataContext();
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        if (!CopyrightManager.getInstance(project).hasAnyCopyrights()) {
            return false;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null || !FileTypeUtil.isSupportedFile(file)) {
                return false;
            }
        } else if (files != null && FileUtil.areFiles(files)) {
            boolean copyrightEnabled = false;
            for (VirtualFile vfile : files) {
                if (!FileTypeUtil.getInstance().isSupportedFile(vfile)) continue;
                copyrightEnabled = true;
                break;
            }
            if (!copyrightEnabled) {
                return false;
            }
        } else if ((files == null || files.length != 1) && LangDataKeys.MODULE_CONTEXT.getData(context) == null && LangDataKeys.MODULE_CONTEXT_ARRAY.getData(context) == null && PlatformDataKeys.PROJECT_CONTEXT.getData(context) == null && (elems = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context)) != null) {
            boolean copyrightEnabled = false;
            for (PsiElement elem : elems) {
                PsiFile file;
                if (elem instanceof PsiDirectory || (file = elem.getContainingFile()) != null && FileTypeUtil.getInstance().isSupportedFile(file.getVirtualFile())) continue;
                copyrightEnabled = true;
                break;
            }
            if (!copyrightEnabled) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new TitledSeparator());
        this.myUpdateExistingCopyrightsCb = new JCheckBox("Update existing copyrights", PropertiesComponent.getInstance().getBoolean(UPDATE_EXISTING_COPYRIGHTS, true));
        panel.add(this.myUpdateExistingCopyrightsCb);
        return panel;
    }

    protected void analyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction", "analyze"));
        }
        PropertiesComponent.getInstance().setValue(UPDATE_EXISTING_COPYRIGHTS, String.valueOf(this.myUpdateExistingCopyrightsCb.isSelected()), "true");
        final LinkedHashMap preparations = new LinkedHashMap();
        Task.Backgroundable task = new Task.Backgroundable(project, "Prepare Copyright...", true){

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction$1", "run"));
                }
                scope.accept(new PsiElementVisitor(){

                    public void visitFile(PsiFile file) {
                        if (indicator.isCanceled()) {
                            return;
                        }
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                        UpdateCopyrightProcessor processor = new UpdateCopyrightProcessor(project, module, file);
                        Runnable runnable = processor.preprocessFile(file, UpdateCopyrightAction.this.myUpdateExistingCopyrightsCb.isSelected());
                        if (runnable != EmptyRunnable.getInstance()) {
                            preparations.put(file, runnable);
                        }
                    }
                });
            }

            public void onSuccess() {
                if (!preparations.isEmpty()) {
                    if (!FileModificationService.getInstance().preparePsiElementsForWrite(preparations.keySet())) {
                        return;
                    }
                    SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, "Update Copyright", true);
                    progressTask.setMinIterationTime(200L);
                    progressTask.setTask((SequentialTask)new UpdateCopyrightSequentialTask(preparations, progressTask));
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/maddyhome/idea/copyright/actions/UpdateCopyrightAction$1", "lambda$onSuccess$0"));
                        }
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                        ProgressManager.getInstance().run((Task)progressTask);
                    }, UpdateCopyrightAction.this.getTemplatePresentation().getText(), null);
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static class UpdateCopyrightSequentialTask
    implements SequentialTask {
        private final int mySize;
        private final Iterator<Runnable> myRunnables;
        private final SequentialModalProgressTask myProgressTask;
        private int myIdx = 0;

        private UpdateCopyrightSequentialTask(Map<PsiFile, Runnable> runnables, SequentialModalProgressTask progressTask) {
            this.myRunnables = runnables.values().iterator();
            this.myProgressTask = progressTask;
            this.mySize = runnables.size();
        }

        public void prepare() {
        }

        public boolean isDone() {
            return this.myIdx > this.mySize - 1;
        }

        public boolean iteration() {
            ProgressIndicator indicator = this.myProgressTask.getIndicator();
            if (indicator != null) {
                indicator.setFraction((double)this.myIdx / (double)this.mySize);
            }
            this.myRunnables.next().run();
            ++this.myIdx;
            return true;
        }

        public void stop() {
            this.myIdx = this.mySize;
        }
    }
}

