/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.action;

import com.intellij.application.options.codeStyle.arrangement.action.AddArrangementRuleAction;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import org.jetbrains.annotations.NotNull;

public class AddArrangementSectionRuleAction
extends AddArrangementRuleAction {
    public AddArrangementSectionRuleAction() {
        this.getTemplatePresentation().setText(ApplicationBundle.message((String)"arrangement.action.section.rule.add.text", (Object[])new Object[0]));
        this.getTemplatePresentation().setDescription(ApplicationBundle.message((String)"arrangement.action.section.rule.add.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(SystemInfoRt.isMac ? AllIcons.CodeStyle.Mac.AddNewSectionRule : AllIcons.CodeStyle.AddNewSectionRule);
    }

    @Override
    public void update(AnActionEvent e) {
        ArrangementMatchingRulesControl control = this.getRulesControl(e);
        if (control == null || !(control instanceof ArrangementSectionRulesControl)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(((ArrangementSectionRulesControl)control).getSectionRuleManager() != null);
    }

    @Override
    @NotNull
    protected Object createNewRule(@NotNull ArrangementMatchingRulesControl control) {
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/application/options/codeStyle/arrangement/action/AddArrangementSectionRuleAction", "createNewRule"));
        }
        ArrangementSectionRuleManager manager = ((ArrangementSectionRulesControl)control).getSectionRuleManager();
        assert (manager != null);
        StdArrangementMatchRule stdArrangementMatchRule = manager.createDefaultSectionRule();
        if (stdArrangementMatchRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/action/AddArrangementSectionRuleAction", "createNewRule"));
        }
        return stdArrangementMatchRule;
    }

    @Override
    protected void showEditor(@NotNull ArrangementMatchingRulesControl control, int rowToEdit) {
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/application/options/codeStyle/arrangement/action/AddArrangementSectionRuleAction", "showEditor"));
        }
        ArrangementSectionRuleManager manager = ((ArrangementSectionRulesControl)control).getSectionRuleManager();
        if (manager != null) {
            manager.showEditor(rowToEdit);
        }
    }
}

