/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Map;

public final class HighlightData {
    private final int myStartOffset;
    private int myEndOffset;
    private final TextAttributesKey myHighlightType;

    public HighlightData(int startOffset, TextAttributesKey highlightType) {
        this.myStartOffset = startOffset;
        this.myHighlightType = highlightType;
    }

    public HighlightData(int startOffset, int endOffset, TextAttributesKey highlightType) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myHighlightType = highlightType;
    }

    public void addHighlToView(final Editor view, EditorColorsScheme scheme, final Map<TextAttributesKey, String> displayText) {
        if (HighlighterColors.BAD_CHARACTER.equals((Object)this.myHighlightType)) {
            return;
        }
        final TextAttributes attr = scheme.getAttributes(this.myHighlightType);
        if (attr != null) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        view.getMarkupModel().addRangeHighlighter(HighlightData.this.myStartOffset, HighlightData.this.myEndOffset, 3000, TextAttributes.ERASE_MARKER, HighlighterTargetArea.EXACT_RANGE);
                        RangeHighlighter highlighter = view.getMarkupModel().addRangeHighlighter(HighlightData.this.myStartOffset, HighlightData.this.myEndOffset, 3000, attr, HighlighterTargetArea.EXACT_RANGE);
                        Color errorStripeColor = attr.getErrorStripeColor();
                        highlighter.setErrorStripeMarkColor(errorStripeColor);
                        String tooltip = (String)displayText.get(HighlightData.this.myHighlightType);
                        highlighter.setErrorStripeTooltip((Object)tooltip);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void setEndOffset(int endOffset) {
        this.myEndOffset = endOffset;
    }

    public String getHighlightType() {
        return this.myHighlightType.getExternalName();
    }
}

