/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EmmetOptions", storages={@Storage(value="emmet.xml")})
public class EmmetOptions
implements PersistentStateComponent<EmmetOptions> {
    private boolean myEmmetEnabled = true;
    private int myEmmetExpandShortcut = 9;
    private boolean myPreviewEnabled = false;
    @NotNull
    private Set<String> myFiltersEnabledByDefault = ContainerUtil.newHashSet();
    private boolean myHrefAutoDetectEnabled = true;
    private boolean myAddEditPointAtTheEndOfTemplate = false;
    @NotNull
    private String myBemElementSeparator = "__";
    @NotNull
    private String myBemModifierSeparator = "_";
    @NotNull
    private String myBemShortElementPrefix = "-";

    @NotNull
    public Set<String> getFiltersEnabledByDefault() {
        Set<String> set = this.myFiltersEnabledByDefault;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getFiltersEnabledByDefault"));
        }
        return set;
    }

    public void setFiltersEnabledByDefault(@NotNull Set<String> filtersEnabledByDefault) {
        if (filtersEnabledByDefault == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filtersEnabledByDefault", "com/intellij/application/options/emmet/EmmetOptions", "setFiltersEnabledByDefault"));
        }
        this.myFiltersEnabledByDefault = filtersEnabledByDefault;
    }

    public boolean isFilterEnabledByDefault(@NotNull ZenCodingFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/application/options/emmet/EmmetOptions", "isFilterEnabledByDefault"));
        }
        return this.myFiltersEnabledByDefault.contains(filter.getSuffix());
    }

    public void setEmmetExpandShortcut(int emmetExpandShortcut) {
        this.myEmmetExpandShortcut = emmetExpandShortcut;
    }

    public int getEmmetExpandShortcut() {
        return this.myEmmetExpandShortcut;
    }

    public boolean isPreviewEnabled() {
        return this.myPreviewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.myPreviewEnabled = previewEnabled;
    }

    public boolean isEmmetEnabled() {
        return this.myEmmetEnabled;
    }

    public void setEmmetEnabled(boolean emmetEnabled) {
        this.myEmmetEnabled = emmetEnabled;
    }

    public void setHrefAutoDetectEnabled(boolean hrefAutoDetectEnabled) {
        this.myHrefAutoDetectEnabled = hrefAutoDetectEnabled;
    }

    public boolean isHrefAutoDetectEnabled() {
        return this.myHrefAutoDetectEnabled;
    }

    public boolean isAddEditPointAtTheEndOfTemplate() {
        return this.myAddEditPointAtTheEndOfTemplate;
    }

    public void setAddEditPointAtTheEndOfTemplate(boolean addEditPointAtTheEndOfTemplate) {
        this.myAddEditPointAtTheEndOfTemplate = addEditPointAtTheEndOfTemplate;
    }

    @NotNull
    public String getBemElementSeparator() {
        String string = this.myBemElementSeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getBemElementSeparator"));
        }
        return string;
    }

    public void setBemElementSeparator(@Nullable String bemElementSeparator) {
        this.myBemElementSeparator = StringUtil.notNullize((String)bemElementSeparator);
    }

    @NotNull
    public String getBemModifierSeparator() {
        String string = this.myBemModifierSeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getBemModifierSeparator"));
        }
        return string;
    }

    public void setBemModifierSeparator(@Nullable String bemModifierSeparator) {
        this.myBemModifierSeparator = StringUtil.notNullize((String)bemModifierSeparator);
    }

    @NotNull
    public String getBemShortElementPrefix() {
        String string = this.myBemShortElementPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetOptions", "getBemShortElementPrefix"));
        }
        return string;
    }

    public void setBemShortElementPrefix(@Nullable String bemShortElementPrefix) {
        this.myBemShortElementPrefix = StringUtil.notNullize((String)bemShortElementPrefix);
    }

    @Nullable
    public EmmetOptions getState() {
        return this;
    }

    public void loadState(EmmetOptions state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public static EmmetOptions getInstance() {
        return (EmmetOptions)ServiceManager.getService(EmmetOptions.class);
    }
}

