/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public final class CodeSmellInfo {
    @NotNull
    private final Document myDocument;
    private final String myDescription;
    private final TextRange myTextRange;
    private final HighlightSeverity mySeverity;

    public CodeSmellInfo(@NotNull Document document2, String description, TextRange textRange, HighlightSeverity severity) {
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/CodeSmellInfo", "<init>"));
        }
        this.myDocument = document2;
        this.myDescription = description;
        this.myTextRange = textRange;
        this.mySeverity = severity;
    }

    @NotNull
    public Document getDocument() {
        Document document2 = this.myDocument;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/CodeSmellInfo", "getDocument"));
        }
        return document2;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public TextRange getTextRange() {
        return this.myTextRange;
    }

    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public int getStartLine() {
        return this.getDocument().getLineNumber(this.getTextRange().getStartOffset());
    }

    public int getStartColumn() {
        return this.getTextRange().getStartOffset() - this.getDocument().getLineStartOffset(this.getStartLine());
    }
}

