/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlCompletionData;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.XmlTextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.XmlTokenTypeFilter;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class DtdCompletionData
extends CompletionData {
    public DtdCompletionData() {
        LeftNeighbour entityFilter = new LeftNeighbour(new XmlTextFilter("%"));
        this.declareFinalScope(XmlToken.class);
        CompletionVariant variant = new CompletionVariant(new AndFilter((ElementFilter)new LeftNeighbour(new OrFilter(new XmlTextFilter("#", "!", "(", ",", "|", "["), new XmlTokenTypeFilter(XmlTokenType.XML_NAME))), (ElementFilter)new NotFilter(entityFilter)));
        variant.includeScopeClass(XmlToken.class, true);
        variant.addCompletion(new String[]{"#PCDATA", "#IMPLIED", "#REQUIRED", "#FIXED", "<!ATTLIST", "<!ELEMENT", "<!NOTATION", "INCLUDE", "IGNORE", "CDATA", "ID", "IDREF", "EMPTY", "ANY", "IDREFS", "ENTITIES", "ENTITY", "<!ENTITY", "NMTOKEN", "NMTOKENS", "SYSTEM", "PUBLIC"}, TailType.NONE);
        variant.setInsertHandler(new MyInsertHandler());
        this.registerVariant(variant);
        variant = new CompletionVariant(entityFilter);
        variant.includeScopeClass(XmlToken.class, true);
        variant.addCompletion(new DtdEntityGetter());
        variant.setInsertHandler(new XmlCompletionData.EntityRefInsertHandler());
        this.registerVariant(variant);
    }

    @Override
    public String findPrefix(PsiElement insertedElement, int offset) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)insertedElement);
        PsiElement prevPrevLeaf = prevLeaf != null ? PsiTreeUtil.prevLeaf((PsiElement)prevLeaf) : null;
        String prefix = super.findPrefix(insertedElement, offset);
        if (prevLeaf != null) {
            String prevLeafText = prevLeaf.getText();
            if ("#".equals(prevLeafText)) {
                prefix = "#" + prefix;
            } else if ("!".equals(prevLeafText) && prevPrevLeaf != null && "<".equals(prevPrevLeaf.getText())) {
                prefix = "<!" + prefix;
            }
        }
        return prefix;
    }

    static class MyInsertHandler
    extends BasicInsertHandler {
        MyInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            if (item.getObject().toString().startsWith("<!")) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                int caretOffset = context.getEditor().getCaretModel().getOffset();
                PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), PsiNamedElement.class);
                if (tag == null) {
                    context.getEditor().getDocument().insertString(caretOffset, (CharSequence)" >");
                    context.getEditor().getCaretModel().moveToOffset(caretOffset + 1);
                }
            }
        }
    }

    static class DtdEntityGetter
    implements ContextGetter {
        DtdEntityGetter() {
        }

        @Override
        public Object[] get(PsiElement context, CompletionContext completionContext) {
            final LinkedList results = new LinkedList();
            PsiElementProcessor processor2 = new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    XmlEntityDecl xmlEntityDecl;
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/DtdCompletionData$DtdEntityGetter$1", "execute"));
                    }
                    if (element instanceof XmlEntityDecl && (xmlEntityDecl = (XmlEntityDecl)element).isInternalReference()) {
                        results.add(xmlEntityDecl.getName());
                    }
                    return true;
                }
            };
            XmlUtil.processXmlElements((XmlElement)((XmlFile)context.getContainingFile().getOriginalFile()), processor2, true);
            return ArrayUtil.toObjectArray(results);
        }
    }
}

