/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public class JavaReferenceCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/codeInsight/completion/JavaReferenceCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/completion/JavaReferenceCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (Registry.is((String)"ide.java.completion.autopopup.only.on.qualified.references")) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)(offset - 1), PsiJavaCodeReferenceElement.class, (boolean)false);
            if (ref != null && !ref.isQualified()) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaReferenceCompletionConfidence", "shouldSkipAutopopup"));
                }
                return threeState;
            }
            if (PsiUtilCore.getElementType((PsiElement)contextElement) == JavaTokenType.AT) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaReferenceCompletionConfidence", "shouldSkipAutopopup"));
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaReferenceCompletionConfidence", "shouldSkipAutopopup"));
        }
        return threeState;
    }
}

